/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.InitializationWrapper;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.internal.testutils.MockLambdaContext;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.servlet.http.HttpServletRequest;
import java.util.concurrent.CountDownLatch;
import org.apache.hc.client5.http.impl.classic.RequestAbortedException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class LambdaContainerHandlerTest {
    private boolean isRuntimeException = false;
    private boolean throwException = false;
    ExceptionContainerHandlerTest handler = new ExceptionContainerHandlerTest(AwsProxyRequest.class, AwsProxyResponse.class, (RequestReader<AwsProxyRequest, HttpServletRequest>)new AwsProxyHttpServletRequestReader(), (ResponseWriter<AwsHttpServletResponse, AwsProxyResponse>)new AwsProxyHttpServletResponseWriter(), (SecurityContextWriter<AwsProxyRequest>)new AwsProxySecurityContextWriter(), (ExceptionHandler<AwsProxyResponse>)new AwsProxyExceptionHandler(), new InitializationWrapper());

    @Test
    void throwRuntime_returnsUnwrappedException() {
        try {
            this.isRuntimeException = true;
            this.throwException = true;
            LambdaContainerHandler.getContainerConfig().setDisableExceptionMapper(true);
            this.handler.proxy(new AwsProxyRequestBuilder("/test", "GET").build(), new MockLambdaContext());
        }
        catch (Exception e) {
            Assertions.assertNotNull((Object)e);
            Assertions.assertEquals((Object)"test RuntimeException", (Object)e.getMessage());
            return;
        }
        Assertions.fail((String)"Did not throw runtime exception");
    }

    @Test
    void throwNonRuntime_returnsWrappedException() {
        try {
            this.isRuntimeException = false;
            this.throwException = true;
            LambdaContainerHandler.getContainerConfig().setDisableExceptionMapper(true);
            this.handler.proxy(new AwsProxyRequestBuilder("/test", "GET").build(), new MockLambdaContext());
        }
        catch (Exception e) {
            Assertions.assertNotNull((Object)e);
            Assertions.assertNotNull((Object)e.getCause());
            Assertions.assertTrue((boolean)(e.getCause() instanceof RequestAbortedException));
            Assertions.assertEquals((Object)"test NonRuntimeException", (Object)e.getCause().getMessage());
            return;
        }
        Assertions.fail((String)"Did not throw exception");
    }

    @Test
    void noException_returnsResponse() {
        this.throwException = false;
        LambdaContainerHandler.getContainerConfig().setDisableExceptionMapper(false);
        AwsProxyResponse resp = (AwsProxyResponse)this.handler.proxy(new AwsProxyRequestBuilder("/test", "GET").build(), new MockLambdaContext());
        Assertions.assertEquals((int)200, (int)resp.getStatusCode());
        Assertions.assertEquals((Object)"OK", (Object)resp.getBody());
    }

    public class ExceptionContainerHandlerTest
    extends LambdaContainerHandler<AwsProxyRequest, AwsProxyResponse, HttpServletRequest, AwsHttpServletResponse> {
        public static final String RUNTIME_MESSAGE = "test RuntimeException";
        public static final String NON_RUNTIME_MESSAGE = "test NonRuntimeException";

        protected ExceptionContainerHandlerTest(Class<AwsProxyRequest> requestClass, Class<AwsProxyResponse> responseClass, RequestReader<AwsProxyRequest, HttpServletRequest> requestReader, ResponseWriter<AwsHttpServletResponse, AwsProxyResponse> responseWriter, SecurityContextWriter<AwsProxyRequest> securityContextWriter, ExceptionHandler<AwsProxyResponse> exceptionHandler, InitializationWrapper init) {
            super(requestClass, responseClass, requestReader, responseWriter, securityContextWriter, exceptionHandler, init);
        }

        protected AwsHttpServletResponse getContainerResponse(HttpServletRequest request, CountDownLatch latch) {
            return new AwsHttpServletResponse(request, latch);
        }

        protected void handleRequest(HttpServletRequest containerRequest, AwsHttpServletResponse containerResponse, Context lambdaContext) throws Exception {
            if (LambdaContainerHandlerTest.this.throwException) {
                if (LambdaContainerHandlerTest.this.isRuntimeException) {
                    throw new RuntimeException(RUNTIME_MESSAGE);
                }
                throw new RequestAbortedException(NON_RUNTIME_MESSAGE);
            }
            containerResponse.setStatus(200);
            containerResponse.getWriter().print("OK");
            containerResponse.flushBuffer();
        }

        public void initialize() throws ContainerInitializationException {
        }
    }
}

