/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy;

import com.amazonaws.serverless.exceptions.InvalidResponseObjectException;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.servlet.http.HttpServletRequest;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResponseWriterTest {
    private static int[][] NAUGHTY_STRINGS = new int[][]{{254}, {255}, {254, 254, 255, 255}};
    private static String[] VALID_STRINGS = new String[]{"\u16a0\u16c7\u16bb\u16eb\u16d2\u16e6\u16a6\u16eb\u16a0\u16b1\u16a9\u16a0\u16a2\u16b1\u16eb\u16a0\u16c1\u16b1\u16aa\u16eb\u16b7\u16d6\u16bb\u16b9\u16e6\u16da\u16b3\u16a2\u16d7\n\u16cb\u16b3\u16d6\u16aa\u16da\u16eb\u16a6\u16d6\u16aa\u16bb\u16eb\u16d7\u16aa\u16be\u16be\u16aa\u16eb\u16b7\u16d6\u16bb\u16b9\u16e6\u16da\u16b3\u16eb\u16d7\u16c1\u16b3\u16da\u16a2\u16be\u16eb\u16bb\u16e6\u16cf\u16eb\u16de\u16ab\u16da\u16aa\u16be\n\u16b7\u16c1\u16a0\u16eb\u16bb\u16d6\u16eb\u16b9\u16c1\u16da\u16d6\u16eb\u16a0\u16a9\u16b1\u16eb\u16de\u16b1\u16c1\u16bb\u16cf\u16be\u16d6\u16eb\u16de\u16a9\u16d7\u16d6\u16cb\u16eb\u16bb\u16da\u16c7\u16cf\u16aa\u16be\u16ec", "\u03a4\u03b7 \u03b3\u03bb\u03ce\u03c3\u03c3\u03b1 \u03bc\u03bf\u03c5 \u03ad\u03b4\u03c9\u03c3\u03b1\u03bd \u03b5\u03bb\u03bb\u03b7\u03bd\u03b9\u03ba\u03ae\n\u03c4\u03bf \u03c3\u03c0\u03af\u03c4\u03b9 \u03c6\u03c4\u03c9\u03c7\u03b9\u03ba\u03cc \u03c3\u03c4\u03b9\u03c2 \u03b1\u03bc\u03bc\u03bf\u03c5\u03b4\u03b9\u03ad\u03c2 \u03c4\u03bf\u03c5 \u039f\u03bc\u03ae\u03c1\u03bf\u03c5.\n\u039c\u03bf\u03bd\u03ac\u03c7\u03b7 \u03ad\u03b3\u03bd\u03bf\u03b9\u03b1 \u03b7 \u03b3\u03bb\u03ce\u03c3\u03c3\u03b1 \u03bc\u03bf\u03c5 \u03c3\u03c4\u03b9\u03c2 \u03b1\u03bc\u03bc\u03bf\u03c5\u03b4\u03b9\u03ad\u03c2 \u03c4\u03bf\u03c5 \u039f\u03bc\u03ae\u03c1\u03bf\u03c5.", "\u10d5\u10d4\u10de\u10ee\u10d8\u10e1 \u10e2\u10e7\u10d0\u10dd\u10e1\u10d0\u10dc\u10d8 \u10e8\u10dd\u10d7\u10d0 \u10e0\u10e3\u10e1\u10d7\u10d0\u10d5\u10d4\u10da\u10d8\n\u10e6\u10db\u10d4\u10e0\u10d7\u10e1\u10d8 \u10e8\u10d4\u10db\u10d5\u10d4\u10d3\u10e0\u10d4, \u10dc\u10e3\u10d7\u10e3 \u10d9\u10d5\u10da\u10d0 \u10d3\u10d0\u10db\u10ee\u10e1\u10dc\u10d0\u10e1 \u10e1\u10dd\u10e4\u10da\u10d8\u10e1\u10d0 \u10e8\u10e0\u10dd\u10db\u10d0\u10e1\u10d0, \u10ea\u10d4\u10ea\u10ee\u10da\u10e1, \u10ec\u10e7\u10d0\u10da\u10e1\u10d0 \u10d3\u10d0 \u10db\u10d8\u10ec\u10d0\u10e1\u10d0, \u10f0\u10d0\u10d4\u10e0\u10d7\u10d0 \u10d7\u10d0\u10dc\u10d0 \u10db\u10e0\u10dd\u10db\u10d0\u10e1\u10d0; \u10db\u10dd\u10db\u10ea\u10dc\u10d4\u10e1 \u10e4\u10e0\u10d7\u10d4\u10dc\u10d8 \u10d3\u10d0 \u10d0\u10e6\u10d5\u10e4\u10e0\u10d8\u10dc\u10d3\u10d4, \u10db\u10d8\u10d5\u10f0\u10ee\u10d5\u10d3\u10d4 \u10db\u10d0\u10e1 \u10e9\u10d4\u10db\u10e1\u10d0 \u10dc\u10d3\u10dd\u10db\u10d0\u10e1\u10d0, \u10d3\u10e6\u10d8\u10e1\u10d8\u10d7 \u10d3\u10d0 \u10e6\u10d0\u10db\u10d8\u10d7 \u10d5\u10f0\u10ee\u10d4\u10d3\u10d5\u10d8\u10d3\u10d4 \u10db\u10d6\u10d8\u10e1\u10d0 \u10d4\u10da\u10d5\u10d0\u10d7\u10d0 \u10d9\u10e0\u10d7\u10dd\u10db\u10d0\u10d0\u10e1\u10d0.", "\u0cac\u0cbe \u0c87\u0cb2\u0ccd\u0cb2\u0cbf \u0cb8\u0c82\u0cad\u0cb5\u0cbf\u0cb8\u0cc1 \u0c87\u0c82\u0ca6\u0cc6\u0ca8\u0ccd\u0ca8 \u0cb9\u0cc3\u0ca6\u0caf\u0ca6\u0cb2\u0cbf \n\u0ca8\u0cbf\u0ca4\u0ccd\u0caf\u0cb5\u0cc2 \u0c85\u0cb5\u0ca4\u0cb0\u0cbf\u0caa \u0cb8\u0ca4\u0ccd\u0caf\u0cbe\u0cb5\u0ca4\u0cbe\u0cb0\n\u0cae\u0ca3\u0ccd\u0ca3\u0cbe\u0c97\u0cbf \u0cae\u0cb0\u0cb5\u0cbe\u0c97\u0cbf \u0cae\u0cbf\u0c97\u0cb5\u0cbe\u0c97\u0cbf \u0c95\u0c97\u0cb5\u0cbe\u0c97\u0cc0... \n\u0cae\u0ca3\u0ccd\u0ca3\u0cbe\u0c97\u0cbf \u0cae\u0cb0\u0cb5\u0cbe\u0c97\u0cbf \u0cae\u0cbf\u0c97\u0cb5\u0cbe\u0c97\u0cbf \u0c95\u0c97\u0cb5\u0cbe\u0c97\u0cbf \n\u0cad\u0cb5 \u0cad\u0cb5\u0ca6\u0cbf \u0cad\u0ca4\u0cbf\u0cb8\u0cbf\u0cb9\u0cc7 \u0cad\u0cb5\u0ca4\u0cbf \u0ca6\u0cc2\u0cb0 \n\u0ca8\u0cbf\u0ca4\u0ccd\u0caf\u0cb5\u0cc2 \u0c85\u0cb5\u0ca4\u0cb0\u0cbf\u0caa \u0cb8\u0ca4\u0ccd\u0caf\u0cbe\u0cb5\u0ca4\u0cbe\u0cb0 || \u0cac\u0cbe \u0c87\u0cb2\u0ccd\u0cb2\u0cbf ||"};

    @Test
    public void isValidUtf8_testNaughtyStrings_allShouldFail() {
        MockResponseWriter rw = new MockResponseWriter();
        for (int[] s : NAUGHTY_STRINGS) {
            byte[] buf = new byte[s.length * 4];
            int pos = 0;
            for (int v : s) {
                byte[] byArray = ResponseWriterTest.convert2Bytes(v);
                int n = byArray.length;
                for (int i = 0; i < n; ++i) {
                    byte b;
                    buf[pos] = b = byArray[i];
                    ++pos;
                }
            }
            Assertions.assertFalse((boolean)rw.isValidUtf8(buf));
        }
    }

    @Test
    public void isValidUtf8_testUtf8Strings_allShouldSucceed() {
        MockResponseWriter rw = new MockResponseWriter();
        for (String s : VALID_STRINGS) {
            Assertions.assertTrue((boolean)rw.isValidUtf8(s.getBytes()));
        }
    }

    public static byte[] convert2Bytes(int src) {
        byte[] tgt = new byte[4];
        int mask = 255;
        tgt[3] = (byte)(src >>> 24);
        tgt[2] = (byte)(src >> 16 & 0xFF);
        tgt[1] = (byte)(src >> 8 & 0xFF);
        tgt[0] = (byte)(src & 0xFF);
        return tgt;
    }

    public class MockResponseWriter
    extends ResponseWriter<AwsProxyHttpServletRequest, HttpServletRequest> {
        public HttpServletRequest writeResponse(AwsProxyHttpServletRequest containerResponse, Context lambdaContext) throws InvalidResponseObjectException {
            return null;
        }

        public boolean testValidUtf8(byte[] input) {
            return this.isValidUtf8(input);
        }
    }
}

