/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy;

import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.testutils.AwsProxyRequestBuilder;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.services.lambda.runtime.Context;
import jakarta.ws.rs.core.SecurityContext;
import java.lang.reflect.Method;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AwsProxySecurityContextWriterTest {
    private AwsProxySecurityContextWriter writer;

    @BeforeEach
    public void setUp() {
        this.writer = new AwsProxySecurityContextWriter();
    }

    @Test
    void write_returnClass_securityContext() throws NoSuchMethodException {
        Method writeMethod = this.writer.getClass().getMethod("writeSecurityContext", AwsProxyRequest.class, Context.class);
        Assertions.assertEquals(SecurityContext.class, writeMethod.getReturnType());
    }

    @Test
    void write_noAuth_emptySecurityContext() {
        AwsProxyRequest request = new AwsProxyRequestBuilder("/test").build();
        SecurityContext context = this.writer.writeSecurityContext(request, null);
        Assertions.assertNotNull((Object)context);
        Assertions.assertNull((Object)context.getAuthenticationScheme());
        Assertions.assertFalse((boolean)context.isSecure());
    }
}

