/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsAsyncContext;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletInputStream;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.RequestSource;
import com.amazonaws.services.lambda.runtime.Context;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.RequestDispatcher;
import jakarta.servlet.ServletConnection;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpUpgradeHandler;
import jakarta.servlet.http.Part;
import jakarta.ws.rs.core.SecurityContext;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsProxyHttpServletRequest
extends AwsHttpServletRequest {
    private AwsProxyRequest request;
    private SecurityContext securityContext;
    private AwsAsyncContext asyncContext;
    private static Logger log = LoggerFactory.getLogger(AwsProxyHttpServletRequest.class);
    private ContainerConfig config;

    public AwsProxyHttpServletRequest(AwsProxyRequest awsProxyRequest, Context lambdaContext, SecurityContext awsSecurityContext) {
        this(awsProxyRequest, lambdaContext, awsSecurityContext, LambdaContainerHandler.getContainerConfig());
    }

    public AwsProxyHttpServletRequest(AwsProxyRequest awsProxyRequest, Context lambdaContext, SecurityContext awsSecurityContext, ContainerConfig config) {
        super(lambdaContext);
        this.request = awsProxyRequest;
        this.securityContext = awsSecurityContext;
        this.config = config;
    }

    public AwsProxyRequest getAwsProxyRequest() {
        return this.request;
    }

    public String getAuthType() {
        return this.securityContext.getAuthenticationScheme();
    }

    public Cookie[] getCookies() {
        if (this.request.getMultiValueHeaders() == null) {
            return new Cookie[0];
        }
        String cookieHeader = (String)this.request.getMultiValueHeaders().getFirst("Cookie");
        if (cookieHeader == null) {
            return new Cookie[0];
        }
        return this.parseCookieHeaderValue(cookieHeader);
    }

    public long getDateHeader(String s) {
        if (this.request.getMultiValueHeaders() == null) {
            return -1L;
        }
        String dateString = (String)this.request.getMultiValueHeaders().getFirst(s);
        if (dateString == null) {
            return -1L;
        }
        try {
            return Instant.from(ZonedDateTime.parse(dateString, dateFormatter)).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            log.warn("Invalid date header in request" + SecurityUtils.crlf(dateString));
            return -1L;
        }
    }

    public String getHeader(String s) {
        List<String> values = this.getHeaderValues(s);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public Enumeration<String> getHeaders(String s) {
        if (this.request.getMultiValueHeaders() == null || this.request.getMultiValueHeaders().get(s) == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.request.getMultiValueHeaders().get(s));
    }

    public Enumeration<String> getHeaderNames() {
        if (this.request.getMultiValueHeaders() == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.request.getMultiValueHeaders().keySet());
    }

    public int getIntHeader(String s) {
        if (this.request.getMultiValueHeaders() == null) {
            return -1;
        }
        String headerValue = (String)this.request.getMultiValueHeaders().getFirst(s);
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public String getMethod() {
        return this.request.getHttpMethod();
    }

    public String getPathInfo() {
        String pathInfo = AwsProxyHttpServletRequest.cleanUri(this.request.getPath());
        return AwsProxyHttpServletRequest.decodeRequestPath(pathInfo, LambdaContainerHandler.getContainerConfig());
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        return this.generateContextPath(this.config, this.request.getRequestContext().getStage());
    }

    public String getQueryString() {
        try {
            return this.generateQueryString(this.request.getMultiValueQueryStringParameters(), this.request.getRequestSource() != RequestSource.ALB, this.config.getUriEncoding());
        }
        catch (ServletException e) {
            log.error("Could not generate query string", (Throwable)e);
            return null;
        }
    }

    public String getRemoteUser() {
        return this.securityContext.getUserPrincipal().getName();
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return this.securityContext.getUserPrincipal();
    }

    public String getRequestURI() {
        return AwsProxyHttpServletRequest.cleanUri(this.getContextPath()) + AwsProxyHttpServletRequest.cleanUri(this.request.getPath());
    }

    public StringBuffer getRequestURL() {
        return this.generateRequestURL(this.request.getPath());
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String s, String s1) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.getMultipartFormParametersMap().values();
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.getMultipartFormParametersMap().get(s);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public String getCharacterEncoding() {
        if (this.request.getMultiValueHeaders() == null) {
            return this.config.getDefaultContentCharset();
        }
        return this.parseCharacterEncoding((String)this.request.getMultiValueHeaders().getFirst("Content-Type"));
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        String currentContentType;
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        if ((currentContentType = (String)this.request.getMultiValueHeaders().getFirst("Content-Type")) == null || "".equals(currentContentType)) {
            log.debug("Called set character encoding to " + SecurityUtils.crlf(s) + " on a request without a content type. Character encoding will not be set");
            return;
        }
        this.request.getMultiValueHeaders().putSingle("Content-Type", this.appendCharacterEncoding(currentContentType, s));
    }

    public int getContentLength() {
        String headerValue = (String)this.request.getMultiValueHeaders().getFirst("Content-Length");
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public long getContentLengthLong() {
        String headerValue = (String)this.request.getMultiValueHeaders().getFirst("Content-Length");
        if (headerValue == null) {
            return -1L;
        }
        return Long.parseLong(headerValue);
    }

    public String getContentType() {
        String contentTypeHeader = (String)this.request.getMultiValueHeaders().getFirst("Content-Type");
        if (contentTypeHeader == null || "".equals(contentTypeHeader.trim())) {
            return null;
        }
        return contentTypeHeader;
    }

    public String getParameter(String s) {
        String queryStringParameter = this.getFirstQueryParamValue(this.request.getMultiValueQueryStringParameters(), s, this.config.isQueryStringCaseSensitive());
        if (queryStringParameter != null) {
            return queryStringParameter;
        }
        String[] bodyParams = this.getFormBodyParameterCaseInsensitive(s);
        if (bodyParams.length == 0) {
            return null;
        }
        return bodyParams[0];
    }

    public Enumeration<String> getParameterNames() {
        Set<String> formParameterNames = this.getFormUrlEncodedParametersMap().keySet();
        if (this.request.getMultiValueQueryStringParameters() == null) {
            return Collections.enumeration(formParameterNames);
        }
        return Collections.enumeration(Stream.concat(formParameterNames.stream(), this.request.getMultiValueQueryStringParameters().keySet().stream()).collect(Collectors.toSet()));
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public String[] getParameterValues(String s) {
        ArrayList<String> values = new ArrayList<String>(Arrays.asList(this.getQueryParamValues(this.request.getMultiValueQueryStringParameters(), s, this.config.isQueryStringCaseSensitive())));
        values.addAll(Arrays.asList(this.getFormBodyParameterCaseInsensitive(s)));
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        return this.generateParameterMap(this.request.getMultiValueQueryStringParameters(), this.config);
    }

    public String getProtocol() {
        return this.request.getRequestContext().getProtocol();
    }

    public String getScheme() {
        return this.getSchemeFromHeader(this.request.getMultiValueHeaders());
    }

    @Override
    public String getServerName() {
        String hostHeader;
        String region = System.getenv("AWS_REGION");
        if (region == null) {
            region = "us-east-1";
        }
        if (this.request.getMultiValueHeaders() != null && this.request.getMultiValueHeaders().containsKey("Host") && SecurityUtils.isValidHost(hostHeader = (String)this.request.getMultiValueHeaders().getFirst("Host"), this.request.getRequestContext().getApiId(), region)) {
            return hostHeader;
        }
        return this.request.getRequestContext().getApiId() + ".execute-api." + region + ".amazonaws.com";
    }

    @Override
    public int getServerPort() {
        if (this.request.getMultiValueHeaders() == null) {
            return 443;
        }
        String port = (String)this.request.getMultiValueHeaders().getFirst("X-Forwarded-Port");
        if (SecurityUtils.isValidPort(port)) {
            return Integer.parseInt(port);
        }
        return 443;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.requestInputStream == null) {
            this.requestInputStream = new AwsServletInputStream((InputStream)this.bodyStringToInputStream(this.request.getBody(), this.request.isBase64Encoded()));
        }
        return this.requestInputStream;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new StringReader(this.request.getBody()));
    }

    public String getRemoteAddr() {
        if (this.request.getRequestContext() == null || this.request.getRequestContext().getIdentity() == null) {
            return "127.0.0.1";
        }
        return this.request.getRequestContext().getIdentity().getSourceIp();
    }

    public String getRemoteHost() {
        return (String)this.request.getMultiValueHeaders().getFirst("Host");
    }

    public Locale getLocale() {
        List<Locale> locales = this.parseAcceptLanguageHeader((String)this.request.getMultiValueHeaders().getFirst("Accept-Language"));
        return locales.size() == 0 ? Locale.getDefault() : locales.get(0);
    }

    public Enumeration<Locale> getLocales() {
        List<Locale> locales = this.parseAcceptLanguageHeader((String)this.request.getMultiValueHeaders().getFirst("Accept-Language"));
        return Collections.enumeration(locales);
    }

    public boolean isSecure() {
        return this.securityContext.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.getServletContext().getRequestDispatcher(s);
    }

    public int getRemotePort() {
        return 0;
    }

    @Override
    public boolean isAsyncSupported() {
        return true;
    }

    @Override
    public boolean isAsyncStarted() {
        if (this.asyncContext == null) {
            return false;
        }
        return !this.asyncContext.isCompleted() && !this.asyncContext.isDispatched();
    }

    public AsyncContext startAsync() throws IllegalStateException {
        this.asyncContext = new AwsAsyncContext(this, this.response, this.containerHandler);
        this.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", DispatcherType.ASYNC);
        log.debug("Starting async context for request: " + SecurityUtils.crlf(this.request.getRequestContext().getRequestId()));
        return this.asyncContext;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        servletRequest.setAttribute("com.amazonaws.serverless.javacontainer.dispatchertype", (Object)DispatcherType.ASYNC);
        this.asyncContext = new AwsAsyncContext((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse, this.containerHandler);
        log.debug("Starting async context for request: " + SecurityUtils.crlf(this.request.getRequestContext().getRequestId()));
        return this.asyncContext;
    }

    public AsyncContext getAsyncContext() {
        if (this.asyncContext == null) {
            throw new IllegalStateException("Request " + SecurityUtils.crlf(this.request.getRequestContext().getRequestId()) + " is not in asynchronous mode. Call startAsync before attempting to get the async context.");
        }
        return this.asyncContext;
    }

    public String getRequestId() {
        return this.request.getRequestContext().getRequestId();
    }

    public String getProtocolRequestId() {
        return "";
    }

    public ServletConnection getServletConnection() {
        return null;
    }

    private List<String> getHeaderValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        if (this.request.getRequestSource() == RequestSource.API_GATEWAY) {
            if ("referer".equals(key.toLowerCase(Locale.ENGLISH))) {
                values.add(this.request.getRequestContext().getIdentity().getCaller());
                return values;
            }
            if ("user-agent".equals(key.toLowerCase(Locale.ENGLISH))) {
                values.add(this.request.getRequestContext().getIdentity().getUserAgent());
                return values;
            }
        }
        if (this.request.getMultiValueHeaders() == null) {
            return null;
        }
        return this.request.getMultiValueHeaders().get(key);
    }
}

