/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet.filters;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebFilter(filterName="UrlPathValidator", urlPatterns={"/*"})
public class UrlPathValidator
implements Filter {
    public static final int DEFAULT_ERROR_CODE = 404;
    public static final String PARAM_INVALID_STATUS_CODE = "invalid_status_code";
    private int invalidStatusCode;
    private Logger log = LoggerFactory.getLogger(UrlPathValidator.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        if (filterConfig == null) {
            this.invalidStatusCode = 404;
            return;
        }
        if (filterConfig.getInitParameter(PARAM_INVALID_STATUS_CODE) != null) {
            String statusCode = filterConfig.getInitParameter(PARAM_INVALID_STATUS_CODE);
            try {
                this.invalidStatusCode = Integer.parseInt(statusCode);
            }
            catch (NumberFormatException e) {
                this.log.error("Could not parse status code from filter config", (Throwable)e);
                this.invalidStatusCode = 404;
            }
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String path = ((HttpServletRequest)servletRequest).getPathInfo();
        if (path == null) {
            this.setErrorResponse(servletResponse);
            return;
        }
        try {
            new URI(path);
        }
        catch (URISyntaxException e) {
            this.log.error("Invalid uri path in doFilter", (Throwable)e);
            this.setErrorResponse(servletResponse);
            return;
        }
        int slashCount = this.countStrings("/", path);
        int dot2Count = this.countStrings("..", path);
        int slash2Count = this.countStrings("//", path);
        if (dot2Count > 0 && slashCount - slash2Count - 1 <= dot2Count) {
            this.setErrorResponse(servletResponse);
            return;
        }
        filterChain.doFilter(servletRequest, servletResponse);
    }

    public void destroy() {
    }

    public int getInvalidStatusCode() {
        return this.invalidStatusCode;
    }

    private void setErrorResponse(ServletResponse resp) {
        ((HttpServletResponse)resp).setStatus(this.invalidStatusCode);
    }

    private int countStrings(String needle, String haystack) {
        int curIndex = 0;
        int stringCount = 0;
        while (curIndex != -1) {
            if ((curIndex = haystack.indexOf(needle, curIndex)) <= -1) continue;
            ++curIndex;
            ++stringCount;
        }
        return stringCount;
    }
}

