/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class AwsHttpServletRequestWrapper
implements HttpServletRequest {
    private HttpServletRequest originalRequest;
    private String newPath;
    private ServletContext ctx;

    public AwsHttpServletRequestWrapper(HttpServletRequest req, String path) {
        this.originalRequest = req;
        this.newPath = path;
        this.ctx = this.originalRequest.getServletContext();
    }

    public void setServletContext(ServletContext newContext) {
        this.ctx = newContext;
    }

    public String getAuthType() {
        return this.originalRequest.getAuthType();
    }

    public Cookie[] getCookies() {
        return this.originalRequest.getCookies();
    }

    public long getDateHeader(String s) {
        return this.originalRequest.getDateHeader(s);
    }

    @SuppressFBWarnings(value={"SERVLET_HEADER"})
    public String getHeader(String s) {
        return this.originalRequest.getHeader(s);
    }

    public Enumeration<String> getHeaders(String s) {
        return this.originalRequest.getHeaders(s);
    }

    public Enumeration<String> getHeaderNames() {
        return this.originalRequest.getHeaderNames();
    }

    public int getIntHeader(String s) {
        return this.originalRequest.getIntHeader(s);
    }

    public String getMethod() {
        return this.originalRequest.getMethod();
    }

    public String getPathInfo() {
        String pathInfo = AwsProxyHttpServletRequest.cleanUri(this.newPath);
        return AwsHttpServletRequest.decodeRequestPath(pathInfo, LambdaContainerHandler.getContainerConfig());
    }

    public String getPathTranslated() {
        return this.originalRequest.getPathTranslated();
    }

    public String getContextPath() {
        return this.originalRequest.getContextPath();
    }

    @SuppressFBWarnings(value={"SERVLET_QUERY_STRING"}, justification="Already Validated on AwsProxyHttpServletRequest")
    public String getQueryString() {
        return this.originalRequest.getQueryString();
    }

    public String getRemoteUser() {
        return this.originalRequest.getRemoteUser();
    }

    public boolean isUserInRole(String s) {
        return this.originalRequest.isUserInRole(s);
    }

    public Principal getUserPrincipal() {
        return this.originalRequest.getUserPrincipal();
    }

    @SuppressFBWarnings(value={"SERVLET_SESSION_ID"}, justification="Already Validated on AwsProxyHttpServletRequest")
    public String getRequestedSessionId() {
        return this.originalRequest.getRequestedSessionId();
    }

    public String getRequestURI() {
        return AwsProxyHttpServletRequest.cleanUri(this.getContextPath()) + AwsProxyHttpServletRequest.cleanUri(this.newPath);
    }

    public StringBuffer getRequestURL() {
        String url = "";
        url = url + this.getServerName();
        url = url + AwsProxyHttpServletRequest.cleanUri(this.getContextPath());
        url = url + AwsProxyHttpServletRequest.cleanUri(this.newPath);
        return new StringBuffer(this.getScheme() + "://" + url);
    }

    public String getServletPath() {
        return this.originalRequest.getServletPath();
    }

    public HttpSession getSession(boolean b) {
        return this.originalRequest.getSession(b);
    }

    public HttpSession getSession() {
        return this.originalRequest.getSession();
    }

    public String changeSessionId() {
        return this.originalRequest.changeSessionId();
    }

    public boolean isRequestedSessionIdValid() {
        return this.originalRequest.isRequestedSessionIdValid();
    }

    public boolean isRequestedSessionIdFromCookie() {
        return this.originalRequest.isRequestedSessionIdFromCookie();
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.originalRequest.isRequestedSessionIdFromURL();
    }

    public boolean isRequestedSessionIdFromUrl() {
        return this.originalRequest.isRequestedSessionIdFromUrl();
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        return this.originalRequest.authenticate(httpServletResponse);
    }

    public void login(String s, String s1) throws ServletException {
        this.originalRequest.login(s, s1);
    }

    public void logout() throws ServletException {
        this.originalRequest.logout();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.originalRequest.getParts();
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.originalRequest.getPart(s);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        return (T)this.originalRequest.upgrade(aClass);
    }

    public Object getAttribute(String s) {
        return this.originalRequest.getAttribute(s);
    }

    public Enumeration<String> getAttributeNames() {
        return this.originalRequest.getAttributeNames();
    }

    public String getCharacterEncoding() {
        return this.originalRequest.getCharacterEncoding();
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        this.originalRequest.setCharacterEncoding(s);
    }

    public int getContentLength() {
        return this.originalRequest.getContentLength();
    }

    public long getContentLengthLong() {
        return this.originalRequest.getContentLengthLong();
    }

    @SuppressFBWarnings(value={"SERVLET_CONTENT_TYPE"}, justification="Already Validated on AwsProxyHttpServletRequest")
    public String getContentType() {
        return this.originalRequest.getContentType();
    }

    public ServletInputStream getInputStream() throws IOException {
        return this.originalRequest.getInputStream();
    }

    @SuppressFBWarnings(value={"SERVLET_PARAMETER"}, justification="Already Validated on AwsProxyHttpServletRequest")
    public String getParameter(String s) {
        return this.originalRequest.getParameter(s);
    }

    @SuppressFBWarnings(value={"SERVLET_PARAMETER"}, justification="Already Validated on AwsProxyHttpServletRequest")
    public Enumeration<String> getParameterNames() {
        return this.originalRequest.getParameterNames();
    }

    @SuppressFBWarnings(value={"SERVLET_PARAMETER"}, justification="Already Validated on AwsProxyHttpServletRequest")
    public String[] getParameterValues(String s) {
        return this.originalRequest.getParameterValues(s);
    }

    @SuppressFBWarnings(value={"SERVLET_PARAMETER"}, justification="Already Validated on AwsProxyHttpServletRequest")
    public Map<String, String[]> getParameterMap() {
        return this.originalRequest.getParameterMap();
    }

    public String getProtocol() {
        return this.originalRequest.getProtocol();
    }

    public String getScheme() {
        return this.originalRequest.getScheme();
    }

    @SuppressFBWarnings(value={"SERVLET_SERVER_NAME"}, justification="Already Validated on AwsProxyHttpServletRequest")
    public String getServerName() {
        return this.originalRequest.getServerName();
    }

    public int getServerPort() {
        return this.originalRequest.getServerPort();
    }

    public BufferedReader getReader() throws IOException {
        return this.originalRequest.getReader();
    }

    public String getRemoteAddr() {
        return this.originalRequest.getRemoteAddr();
    }

    public String getRemoteHost() {
        return this.originalRequest.getRemoteAddr();
    }

    public void setAttribute(String s, Object o) {
        this.originalRequest.setAttribute(s, o);
    }

    public void removeAttribute(String s) {
        this.originalRequest.removeAttribute(s);
    }

    public Locale getLocale() {
        return this.originalRequest.getLocale();
    }

    public Enumeration<Locale> getLocales() {
        return this.originalRequest.getLocales();
    }

    public boolean isSecure() {
        return this.originalRequest.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.originalRequest.getRequestDispatcher(s);
    }

    public String getRealPath(String s) {
        return this.originalRequest.getRealPath(s);
    }

    public int getRemotePort() {
        return this.originalRequest.getRemotePort();
    }

    public String getLocalName() {
        return this.originalRequest.getLocalName();
    }

    public String getLocalAddr() {
        return this.originalRequest.getLocalAddr();
    }

    public int getLocalPort() {
        return this.originalRequest.getLocalPort();
    }

    public ServletContext getServletContext() {
        return this.ctx;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return this.originalRequest.startAsync();
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return this.originalRequest.startAsync(servletRequest, servletResponse);
    }

    public boolean isAsyncStarted() {
        return this.originalRequest.isAsyncStarted();
    }

    public boolean isAsyncSupported() {
        return this.originalRequest.isAsyncSupported();
    }

    public AsyncContext getAsyncContext() {
        return this.originalRequest.getAsyncContext();
    }

    public DispatcherType getDispatcherType() {
        return this.originalRequest.getDispatcherType();
    }
}

