/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.InitializationWrapper;
import com.amazonaws.serverless.proxy.LogFormatter;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.ws.rs.core.SecurityContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LambdaContainerHandler<RequestType, ResponseType, ContainerRequestType, ContainerResponseType> {
    public static final String SERVER_INFO = "aws-serverless-java-container";
    private RequestReader<RequestType, ContainerRequestType> requestReader;
    private ResponseWriter<ContainerResponseType, ResponseType> responseWriter;
    private SecurityContextWriter<RequestType> securityContextWriter;
    private ExceptionHandler<ResponseType> exceptionHandler;
    private Class<RequestType> requestTypeClass;
    private Class<ResponseType> responseTypeClass;
    private InitializationWrapper initializationWrapper;
    protected Context lambdaContext;
    private LogFormatter<ContainerRequestType, ContainerResponseType> logFormatter;
    private Logger log = LoggerFactory.getLogger(LambdaContainerHandler.class);
    private ObjectReader objectReader;
    private ObjectWriter objectWriter;
    private static ContainerConfig config = ContainerConfig.defaultConfig();
    private static ObjectMapper objectMapper = new ObjectMapper();

    protected LambdaContainerHandler(Class<RequestType> requestClass, Class<ResponseType> responseClass, RequestReader<RequestType, ContainerRequestType> requestReader, ResponseWriter<ContainerResponseType, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler, InitializationWrapper init) {
        this.log.info("Starting Lambda Container Handler");
        this.requestTypeClass = requestClass;
        this.responseTypeClass = responseClass;
        this.requestReader = requestReader;
        this.responseWriter = responseWriter;
        this.securityContextWriter = securityContextWriter;
        this.exceptionHandler = exceptionHandler;
        this.initializationWrapper = init;
        this.objectReader = LambdaContainerHandler.getObjectMapper().readerFor(this.requestTypeClass);
        this.objectWriter = LambdaContainerHandler.getObjectMapper().writerFor(this.responseTypeClass);
    }

    protected LambdaContainerHandler(Class<RequestType> requestClass, Class<ResponseType> responseClass, RequestReader<RequestType, ContainerRequestType> requestReader, ResponseWriter<ContainerResponseType, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler) {
        this(requestClass, responseClass, requestReader, responseWriter, securityContextWriter, exceptionHandler, new InitializationWrapper());
    }

    protected abstract ContainerResponseType getContainerResponse(ContainerRequestType var1, CountDownLatch var2);

    protected abstract void handleRequest(ContainerRequestType var1, ContainerResponseType var2, Context var3) throws Exception;

    public abstract void initialize() throws ContainerInitializationException;

    public static ObjectMapper getObjectMapper() {
        return objectMapper;
    }

    public InitializationWrapper getInitializationWrapper() {
        return this.initializationWrapper;
    }

    public void setInitializationWrapper(InitializationWrapper wrapper) {
        this.initializationWrapper = wrapper;
    }

    public void stripBasePath(String basePath) {
        if (basePath == null || "".equals(basePath)) {
            config.setStripBasePath(false);
            config.setServiceBasePath(null);
        } else {
            config.setStripBasePath(true);
            config.setServiceBasePath(basePath);
        }
    }

    public void setLogFormatter(LogFormatter<ContainerRequestType, ContainerResponseType> formatter) {
        this.logFormatter = formatter;
    }

    public ResponseType proxy(RequestType request, Context context) {
        this.lambdaContext = context;
        CountDownLatch latch = new CountDownLatch(1);
        try {
            SecurityContext securityContext = this.securityContextWriter.writeSecurityContext(request, context);
            ContainerRequestType containerRequest = this.requestReader.readRequest(request, securityContext, context, config);
            ContainerResponseType containerResponse = this.getContainerResponse(containerRequest, latch);
            if (this.initializationWrapper != null && this.initializationWrapper.getInitializationLatch() != null && !this.initializationWrapper.getInitializationLatch().await(config.getInitializationTimeout(), TimeUnit.MILLISECONDS)) {
                throw new ContainerInitializationException("Could not initialize framework within the " + config.getInitializationTimeout() + "ms timeout", null);
            }
            this.handleRequest(containerRequest, containerResponse, context);
            latch.await();
            if (this.logFormatter != null) {
                this.log.info(SecurityUtils.crlf(this.logFormatter.format(containerRequest, containerResponse, securityContext)));
            }
            return this.responseWriter.writeResponse(containerResponse, context);
        }
        catch (Exception e) {
            this.log.error("Error while handling request", (Throwable)e);
            latch.countDown();
            if (LambdaContainerHandler.getContainerConfig().isDisableExceptionMapper()) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
            return this.exceptionHandler.handle(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void proxyStream(InputStream input, OutputStream output, Context context) throws IOException {
        try {
            Object request = this.objectReader.readValue(input);
            ResponseType resp = this.proxy(request, context);
            this.objectWriter.writeValue(output, resp);
        }
        catch (JsonParseException e) {
            this.log.error("Error while parsing request object stream", (Throwable)e);
            LambdaContainerHandler.getObjectMapper().writeValue(output, this.exceptionHandler.handle(e));
        }
        catch (JsonMappingException e) {
            this.log.error("Error while mapping object to RequestType class", (Throwable)e);
            LambdaContainerHandler.getObjectMapper().writeValue(output, this.exceptionHandler.handle(e));
        }
        finally {
            output.flush();
            output.close();
        }
    }

    public static ContainerConfig getContainerConfig() {
        return config;
    }

    static {
        objectMapper.registerModule((Module)new AfterburnerModule());
    }
}

