/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.testutils;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.model.AlbContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayAuthorizerContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestIdentity;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyRequestContext;
import com.amazonaws.serverless.proxy.model.CognitoAuthorizerClaims;
import com.amazonaws.serverless.proxy.model.Headers;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.fasterxml.jackson.core.JsonProcessingException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ByteArrayBody;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class AwsProxyRequestBuilder {
    private AwsProxyRequest request = new AwsProxyRequest();
    private MultipartEntityBuilder multipartBuilder;

    public AwsProxyRequestBuilder() {
        this(null, null);
    }

    public AwsProxyRequestBuilder(String path) {
        this(path, null);
    }

    public AwsProxyRequestBuilder(String path, String httpMethod) {
        this.request.setMultiValueHeaders(new Headers());
        this.request.setHttpMethod(httpMethod);
        this.request.setPath(path);
        this.request.setMultiValueQueryStringParameters(new MultiValuedTreeMap<String, String>());
        this.request.setRequestContext(new AwsProxyRequestContext());
        this.request.getRequestContext().setRequestId(UUID.randomUUID().toString());
        this.request.getRequestContext().setExtendedRequestId(UUID.randomUUID().toString());
        this.request.getRequestContext().setStage("test");
        this.request.getRequestContext().setProtocol("HTTP/1.1");
        this.request.getRequestContext().setRequestTimeEpoch(System.currentTimeMillis());
        ApiGatewayRequestIdentity identity = new ApiGatewayRequestIdentity();
        identity.setSourceIp("127.0.0.1");
        this.request.getRequestContext().setIdentity(identity);
    }

    public AwsProxyRequestBuilder alb() {
        this.request.setRequestContext(new AwsProxyRequestContext());
        this.request.getRequestContext().setElb(new AlbContext());
        this.request.getRequestContext().getElb().setTargetGroupArn("arn:aws:elasticloadbalancing:us-east-1:123456789012:targetgroup/lambda-target/d6190d154bc908a5");
        return this;
    }

    public AwsProxyRequestBuilder stage(String stageName) {
        this.request.getRequestContext().setStage(stageName);
        return this;
    }

    public AwsProxyRequestBuilder method(String httpMethod) {
        this.request.setHttpMethod(httpMethod);
        return this;
    }

    public AwsProxyRequestBuilder path(String path) {
        this.request.setPath(path);
        return this;
    }

    public AwsProxyRequestBuilder json() {
        return this.header("Content-Type", "application/json");
    }

    public AwsProxyRequestBuilder form(String key, String value) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        this.request.getMultiValueHeaders().add("Content-Type", "application/x-www-form-urlencoded");
        String body = this.request.getBody();
        if (body == null) {
            body = "";
        }
        body = body + (body.equals("") ? "" : "&") + key + "=" + value;
        this.request.setBody(body);
        return this;
    }

    public AwsProxyRequestBuilder formFilePart(String fieldName, String fileName, byte[] content) throws IOException {
        if (this.multipartBuilder == null) {
            this.multipartBuilder = MultipartEntityBuilder.create();
        }
        this.multipartBuilder.addPart(fieldName, (ContentBody)new ByteArrayBody(content, fileName));
        this.buildMultipartBody();
        return this;
    }

    public AwsProxyRequestBuilder formFieldPart(String fieldName, String fieldValue) throws IOException {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        if (this.multipartBuilder == null) {
            this.multipartBuilder = MultipartEntityBuilder.create();
        }
        this.multipartBuilder.addPart(fieldName, (ContentBody)new StringBody(fieldValue));
        this.buildMultipartBody();
        return this;
    }

    private void buildMultipartBody() throws IOException {
        HttpEntity bodyEntity = this.multipartBuilder.build();
        InputStream bodyStream = bodyEntity.getContent();
        byte[] buffer = new byte[bodyStream.available()];
        IOUtils.readFully((InputStream)bodyStream, (byte[])buffer);
        byte[] finalBuffer = new byte[buffer.length + 1];
        byte[] newLineBytes = "\n\n".getBytes(LambdaContainerHandler.getContainerConfig().getDefaultContentCharset());
        System.arraycopy(newLineBytes, 0, finalBuffer, 0, newLineBytes.length);
        System.arraycopy(buffer, 0, finalBuffer, newLineBytes.length - 1, buffer.length);
        this.request.setBody(Base64.getMimeEncoder().encodeToString(finalBuffer));
        this.request.setIsBase64Encoded(true);
        this.request.setMultiValueHeaders(new Headers());
        this.header("Content-Type", bodyEntity.getContentType().getValue());
        this.header("Content-Length", bodyEntity.getContentLength() + "");
    }

    public AwsProxyRequestBuilder header(String key, String value) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        this.request.getMultiValueHeaders().add(key, value);
        return this;
    }

    public AwsProxyRequestBuilder queryString(String key, String value) {
        if (this.request.getMultiValueQueryStringParameters() == null) {
            this.request.setMultiValueQueryStringParameters(new MultiValuedTreeMap<String, String>());
        }
        if (this.request.getRequestSource() == AwsProxyRequest.RequestSource.API_GATEWAY) {
            this.request.getMultiValueQueryStringParameters().add(key, value);
        }
        if (this.request.getRequestSource() == AwsProxyRequest.RequestSource.ALB) {
            try {
                this.request.getMultiValueQueryStringParameters().add(key, URLEncoder.encode(value, "ISO-8859-1"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public AwsProxyRequestBuilder body(String body) {
        this.request.setBody(body);
        return this;
    }

    public AwsProxyRequestBuilder nullBody() {
        this.request.setBody(null);
        return this;
    }

    public AwsProxyRequestBuilder body(Object body) {
        if (this.request.getMultiValueHeaders() != null && ((String)this.request.getMultiValueHeaders().getFirst("Content-Type")).equals("application/json")) {
            try {
                return this.body(LambdaContainerHandler.getObjectMapper().writeValueAsString(body));
            }
            catch (JsonProcessingException e) {
                throw new UnsupportedOperationException("Could not serialize object: " + e.getMessage());
            }
        }
        throw new UnsupportedOperationException("Unsupported content type in request");
    }

    public AwsProxyRequestBuilder binaryBody(InputStream is) throws IOException {
        this.request.setIsBase64Encoded(true);
        return this.body(Base64.getMimeEncoder().encodeToString(IOUtils.toByteArray((InputStream)is)));
    }

    public AwsProxyRequestBuilder authorizerPrincipal(String principal) {
        if (this.request.getRequestSource() == AwsProxyRequest.RequestSource.API_GATEWAY) {
            if (this.request.getRequestContext().getAuthorizer() == null) {
                this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
            }
            this.request.getRequestContext().getAuthorizer().setPrincipalId(principal);
            if (this.request.getRequestContext().getAuthorizer().getClaims() == null) {
                this.request.getRequestContext().getAuthorizer().setClaims(new CognitoAuthorizerClaims());
            }
            this.request.getRequestContext().getAuthorizer().getClaims().setSubject(principal);
        }
        if (this.request.getRequestSource() == AwsProxyRequest.RequestSource.ALB) {
            this.header("x-amzn-oidc-identity", principal);
            try {
                this.header("x-amzn-oidc-accesstoken", Base64.getMimeEncoder().encodeToString("test-token".getBytes("ISO-8859-1")));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return this;
    }

    public AwsProxyRequestBuilder authorizerContextValue(String key, String value) {
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setContextValue(key, value);
        return this;
    }

    public AwsProxyRequestBuilder cognitoUserPool(String identityId) {
        this.request.getRequestContext().getIdentity().setCognitoAuthenticationType("POOL");
        this.request.getRequestContext().getIdentity().setCognitoIdentityId(identityId);
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setClaims(new CognitoAuthorizerClaims());
        this.request.getRequestContext().getAuthorizer().getClaims().setSubject(identityId);
        return this;
    }

    public AwsProxyRequestBuilder claim(String claim, String value) {
        this.request.getRequestContext().getAuthorizer().getClaims().setClaim(claim, value);
        return this;
    }

    public AwsProxyRequestBuilder cognitoIdentity(String identityId, String identityPoolId) {
        this.request.getRequestContext().getIdentity().setCognitoAuthenticationType("IDENTITY");
        this.request.getRequestContext().getIdentity().setCognitoIdentityId(identityId);
        this.request.getRequestContext().getIdentity().setCognitoIdentityPoolId(identityPoolId);
        return this;
    }

    public AwsProxyRequestBuilder cookie(String name, String value) {
        String cookies;
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        if ((cookies = (String)this.request.getMultiValueHeaders().getFirst("Cookie")) == null) {
            cookies = "";
        }
        cookies = cookies + (cookies.equals("") ? "" : "; ") + name + "=" + value;
        this.request.getMultiValueHeaders().putSingle("Cookie", cookies);
        return this;
    }

    public AwsProxyRequestBuilder scheme(String scheme) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        this.request.getMultiValueHeaders().putSingle("CloudFront-Forwarded-Proto", scheme);
        return this;
    }

    public AwsProxyRequestBuilder serverName(String serverName) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new Headers());
        }
        this.request.getMultiValueHeaders().putSingle("Host", serverName);
        return this;
    }

    public AwsProxyRequestBuilder userAgent(String agent) {
        if (this.request.getRequestContext() == null) {
            this.request.setRequestContext(new AwsProxyRequestContext());
        }
        if (this.request.getRequestContext().getIdentity() == null) {
            this.request.getRequestContext().setIdentity(new ApiGatewayRequestIdentity());
        }
        this.request.getRequestContext().getIdentity().setUserAgent(agent);
        return this;
    }

    public AwsProxyRequestBuilder referer(String referer) {
        if (this.request.getRequestContext() == null) {
            this.request.setRequestContext(new AwsProxyRequestContext());
        }
        if (this.request.getRequestContext().getIdentity() == null) {
            this.request.getRequestContext().setIdentity(new ApiGatewayRequestIdentity());
        }
        this.request.getRequestContext().getIdentity().setCaller(referer);
        return this;
    }

    public AwsProxyRequestBuilder basicAuth(String username, String password) {
        this.request.getMultiValueHeaders().remove("Authorization");
        String authHeader = "Basic " + Base64.getMimeEncoder().encodeToString((username + ":" + password).getBytes(Charset.defaultCharset()));
        this.request.getMultiValueHeaders().add("Authorization", authHeader);
        return this;
    }

    public AwsProxyRequestBuilder fromJsonString(String jsonContent) throws IOException {
        this.request = (AwsProxyRequest)LambdaContainerHandler.getObjectMapper().readValue(jsonContent, AwsProxyRequest.class);
        return this;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public AwsProxyRequestBuilder fromJsonPath(String filePath) throws IOException {
        this.request = (AwsProxyRequest)LambdaContainerHandler.getObjectMapper().readValue(new File(filePath), AwsProxyRequest.class);
        return this;
    }

    public AwsProxyRequest build() {
        return this.request;
    }

    public InputStream buildStream() {
        try {
            String requestJson = LambdaContainerHandler.getObjectMapper().writeValueAsString((Object)this.request);
            return new ByteArrayInputStream(requestJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

