/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.ContainerInitializationException;
import com.amazonaws.serverless.proxy.AsyncInitializationWrapper;
import com.amazonaws.serverless.proxy.AwsProxyExceptionHandler;
import com.amazonaws.serverless.proxy.AwsProxySecurityContextWriter;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.InitializationWrapper;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletResponse;
import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletResponseWriter;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;

public abstract class ServletLambdaContainerHandlerBuilder<RequestType, ResponseType, ContainerRequestType extends HttpServletRequest, HandlerType extends AwsLambdaServletContainerHandler<RequestType, ResponseType, ContainerRequestType, AwsHttpServletResponse>, Builder extends ServletLambdaContainerHandlerBuilder<RequestType, ResponseType, ContainerRequestType, HandlerType, Builder>> {
    private static final String MISSING_FIELD_ERROR = "Missing %s in lambda container handler builder";
    protected InitializationWrapper initializationWrapper;
    protected RequestReader<RequestType, ContainerRequestType> requestReader;
    protected ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter;
    protected SecurityContextWriter<RequestType> securityContextWriter;
    protected ExceptionHandler<ResponseType> exceptionHandler;
    protected Class<RequestType> requestTypeClass;
    protected Class<ResponseType> responseTypeClass;

    protected void validate() throws ContainerInitializationException {
        ArrayList<String> errFields = new ArrayList<String>();
        if (this.requestTypeClass == null) {
            errFields.add("request type class");
        }
        if (this.responseTypeClass == null) {
            errFields.add("response type class");
        }
        if (this.requestReader == null) {
            errFields.add("request reader");
        }
        if (this.responseWriter == null) {
            errFields.add("response writer");
        }
        if (this.securityContextWriter == null) {
            errFields.add("security context writer");
        }
        if (this.exceptionHandler == null) {
            errFields.add("exception handler");
        }
        if (this.initializationWrapper == null) {
            errFields.add("initialization wrapper");
        }
        if (!errFields.isEmpty()) {
            throw new ContainerInitializationException(String.format(MISSING_FIELD_ERROR, String.join((CharSequence)", ", errFields)), null);
        }
    }

    public Builder defaultProxy() {
        ((ServletLambdaContainerHandlerBuilder)((ServletLambdaContainerHandlerBuilder)((ServletLambdaContainerHandlerBuilder)((ServletLambdaContainerHandlerBuilder)((ServletLambdaContainerHandlerBuilder)((ServletLambdaContainerHandlerBuilder)this.initializationWrapper(new InitializationWrapper())).requestReader(new AwsProxyHttpServletRequestReader())).responseWriter(new AwsProxyHttpServletResponseWriter())).securityContextWriter(new AwsProxySecurityContextWriter())).exceptionHandler(new AwsProxyExceptionHandler())).requestTypeClass(AwsProxyRequest.class)).responseTypeClass(AwsProxyResponse.class);
        return this.self();
    }

    public Builder initializationWrapper(InitializationWrapper initializationWrapper) {
        this.initializationWrapper = initializationWrapper;
        return this.self();
    }

    public Builder requestReader(RequestReader<RequestType, ContainerRequestType> requestReader) {
        this.requestReader = requestReader;
        return this.self();
    }

    public Builder responseWriter(ResponseWriter<AwsHttpServletResponse, ResponseType> responseWriter) {
        this.responseWriter = responseWriter;
        return this.self();
    }

    public Builder securityContextWriter(SecurityContextWriter<RequestType> securityContextWriter) {
        this.securityContextWriter = securityContextWriter;
        return this.self();
    }

    public Builder exceptionHandler(ExceptionHandler<ResponseType> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this.self();
    }

    public Builder requestTypeClass(Class<RequestType> requestType) {
        this.requestTypeClass = requestType;
        return this.self();
    }

    public Builder responseTypeClass(Class<ResponseType> responseType) {
        this.responseTypeClass = responseType;
        return this.self();
    }

    public Builder asyncInit(long actualStartTime) {
        this.initializationWrapper = new AsyncInitializationWrapper(actualStartTime);
        return this.self();
    }

    protected abstract Builder self();

    public abstract HandlerType build() throws ContainerInitializationException;

    public abstract HandlerType buildAndInitialize() throws ContainerInitializationException;
}

