/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.MultipartConfigElement;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletSecurityElement;

public class AwsServletRegistration
implements ServletRegistration,
ServletRegistration.Dynamic {
    private String servletName;
    private Servlet servlet;
    private AwsServletContext ctx;
    private Map<String, String> initParameters;
    private int loadOnStartup;
    private String runAsRole;
    private boolean asyncSupported;
    private Map<String, AwsServletRegistration> servletPathMappings;

    public AwsServletRegistration(String name, Servlet s, AwsServletContext context) {
        this.servletName = name;
        this.servlet = s;
        this.ctx = context;
        this.initParameters = new HashMap<String, String>();
        this.servletPathMappings = new HashMap<String, AwsServletRegistration>();
        this.loadOnStartup = -1;
        this.asyncSupported = true;
    }

    public Set<String> addMapping(String ... strings) {
        HashSet<String> failedMappings = new HashSet<String>();
        for (String s : strings) {
            if (this.servletPathMappings.containsKey(s)) {
                failedMappings.add(s);
                continue;
            }
            this.servletPathMappings.put(s, this);
        }
        return failedMappings;
    }

    public Collection<String> getMappings() {
        return this.servletPathMappings.keySet();
    }

    public String getRunAsRole() {
        return this.runAsRole;
    }

    public String getName() {
        return this.servletName;
    }

    public String getClassName() {
        return this.servlet.getClass().getName();
    }

    public boolean setInitParameter(String s, String s1) {
        if (this.initParameters.containsKey(s)) {
            return false;
        }
        this.initParameters.put(s, s1);
        return true;
    }

    public String getInitParameter(String s) {
        return this.initParameters.get(s);
    }

    public Set<String> setInitParameters(Map<String, String> map) {
        HashSet<String> failedParameters = new HashSet<String>();
        for (Map.Entry<String, String> param : map.entrySet()) {
            if (this.initParameters.containsKey(param.getKey())) {
                failedParameters.add(param.getKey());
            }
            this.initParameters.put(param.getKey(), param.getValue());
        }
        return failedParameters;
    }

    public Map<String, String> getInitParameters() {
        return this.initParameters;
    }

    public Servlet getServlet() throws ServletException {
        if (this.servlet.getServletConfig() == null) {
            this.servlet.init(this.getServletConfig());
        }
        return this.servlet;
    }

    public void setLoadOnStartup(int i) {
        this.loadOnStartup = i;
    }

    public int getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public Set<String> setServletSecurity(ServletSecurityElement servletSecurityElement) {
        return null;
    }

    public void setMultipartConfig(MultipartConfigElement multipartConfigElement) {
    }

    public void setRunAsRole(String s) {
        this.runAsRole = s;
    }

    public void setAsyncSupported(boolean b) {
        this.asyncSupported = b;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public ServletConfig getServletConfig() {
        return new ServletConfig(){

            public String getServletName() {
                return AwsServletRegistration.this.servletName;
            }

            public ServletContext getServletContext() {
                return AwsServletRegistration.this.ctx;
            }

            public String getInitParameter(String s) {
                return (String)AwsServletRegistration.this.initParameters.get(s);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(AwsServletRegistration.this.initParameters.keySet());
            }
        };
    }
}

