/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import javax.ws.rs.core.SecurityContext;

public class AwsProxyHttpServletRequestReader
extends RequestReader<AwsProxyRequest, AwsProxyHttpServletRequest> {
    @Override
    public AwsProxyHttpServletRequest readRequest(AwsProxyRequest request, SecurityContext securityContext, Context lambdaContext, ContainerConfig config) throws InvalidRequestEventException {
        request.setPath(this.stripBasePath(request.getPath(), config));
        if (request.getMultiValueHeaders().getFirst("Content-Type") != null) {
            String contentType = (String)request.getMultiValueHeaders().getFirst("Content-Type");
            request.getMultiValueHeaders().putSingle("Content-Type", this.getContentTypeWithCharset(contentType, config));
        }
        AwsProxyHttpServletRequest servletRequest = new AwsProxyHttpServletRequest(request, lambdaContext, securityContext, config);
        servletRequest.setAttribute("com.amazonaws.apigateway.request.context", request.getRequestContext());
        servletRequest.setAttribute("com.amazonaws.apigateway.stage.variables", request.getStageVariables());
        servletRequest.setAttribute("com.amazonaws.apigateway.request", request);
        servletRequest.setAttribute("com.amazonaws.alb.request.context", request.getRequestContext().getElb());
        servletRequest.setAttribute("com.amazonaws.lambda.context", lambdaContext);
        servletRequest.setAttribute("com.amazonaws.serverless.jaxrs.securityContext", securityContext);
        return servletRequest;
    }

    @Override
    protected Class<? extends AwsProxyRequest> getRequestClass() {
        return AwsProxyRequest.class;
    }

    private String getContentTypeWithCharset(String headerValue, ContainerConfig config) {
        if (headerValue == null || "".equals(headerValue.trim())) {
            return headerValue;
        }
        if (headerValue.contains("charset=")) {
            return headerValue;
        }
        String newValue = headerValue;
        if (!headerValue.trim().endsWith(";")) {
            newValue = newValue + "; ";
        }
        newValue = newValue + "charset=" + config.getDefaultContentCharset();
        return newValue;
    }
}

