/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import java.time.Instant;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsHttpSession
implements HttpSession {
    public static final int SESSION_DURATION_SEC = 1800;
    private static final Logger log = LoggerFactory.getLogger(AwsHttpSession.class);
    private Map<String, Object> attributes;
    private String id;
    private long creationTime;
    private int maxInactiveInterval;
    private long lastAccessedTime;
    private boolean valid;

    public AwsHttpSession(String id) {
        if (null == id) {
            throw new RuntimeException("HTTP session id (from request ID) cannot be null");
        }
        this.id = id;
        this.attributes = new HashMap<String, Object>();
        this.creationTime = Instant.now().getEpochSecond();
        this.maxInactiveInterval = 1800;
        this.lastAccessedTime = this.creationTime;
        this.valid = true;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getId() {
        return this.id;
    }

    public long getLastAccessedTime() {
        return 0L;
    }

    public ServletContext getServletContext() {
        return null;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    @Deprecated
    public HttpSessionContext getSessionContext() {
        throw new UnsupportedOperationException("Session context is deprecated and no longer supported");
    }

    public Object getAttribute(String name) {
        this.touch();
        return this.attributes.get(name);
    }

    @Deprecated
    public Object getValue(String name) {
        throw new UnsupportedOperationException("Session values are deprecated and not supported");
    }

    public Enumeration<String> getAttributeNames() {
        this.touch();
        return Collections.enumeration(this.attributes.keySet());
    }

    @Deprecated
    public String[] getValueNames() {
        throw new UnsupportedOperationException("Session values are deprecated and not supported");
    }

    public void setAttribute(String name, Object value) {
        this.touch();
        this.attributes.put(name, value);
    }

    @Deprecated
    public void putValue(String name, Object value) {
        throw new UnsupportedOperationException("Session values are deprecated and not supported");
    }

    public void removeAttribute(String name) {
        this.touch();
        this.attributes.remove(name);
    }

    @Deprecated
    public void removeValue(String name) {
        throw new UnsupportedOperationException("Session values are deprecated and not supported");
    }

    public void invalidate() {
        this.valid = false;
        this.attributes.clear();
    }

    public boolean isNew() {
        return this.lastAccessedTime == this.creationTime;
    }

    private void touch() {
        this.lastAccessedTime = Instant.now().getEpochSecond();
    }

    boolean isValid() {
        if (this.lastAccessedTime - this.creationTime < (long)this.maxInactiveInterval) {
            return this.valid;
        }
        return false;
    }
}

