/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsLambdaServletContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AwsProxyRequestDispatcher
implements RequestDispatcher {
    private String dispatchPath;
    private AwsLambdaServletContainerHandler lambdaContainerHandler;

    public AwsProxyRequestDispatcher(String path, AwsLambdaServletContainerHandler handler) {
        if (!path.startsWith("/")) {
            throw new UnsupportedOperationException("Only dispatchers with absolute paths are supported");
        }
        this.dispatchPath = path;
        this.lambdaContainerHandler = handler;
    }

    public void forward(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (!(servletRequest instanceof AwsProxyHttpServletRequest)) {
            throw new IOException("Invalid request type: " + servletRequest.getClass().getSimpleName() + ". Only AwsProxyHttpServletRequest is supported");
        }
        if (this.lambdaContainerHandler == null) {
            throw new IOException("Null container handler in dispatcher");
        }
        ((AwsProxyHttpServletRequest)servletRequest).setDispatcherType(DispatcherType.FORWARD);
        ((AwsProxyHttpServletRequest)servletRequest).getAwsProxyRequest().setPath(this.dispatchPath);
        assert (servletResponse instanceof HttpServletResponse) : servletResponse.getClass();
        this.lambdaContainerHandler.forward((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
    }

    public void include(ServletRequest servletRequest, ServletResponse servletResponse) throws ServletException, IOException {
        if (!(servletRequest instanceof AwsProxyHttpServletRequest)) {
            throw new IOException("Invalid request type: " + servletRequest.getClass().getSimpleName() + ". Only AwsProxyHttpServletRequest is supported");
        }
        if (this.lambdaContainerHandler == null) {
            throw new IOException("Null container handler in dispatcher");
        }
        ((AwsProxyHttpServletRequest)servletRequest).setDispatcherType(DispatcherType.INCLUDE);
        ((AwsProxyHttpServletRequest)servletRequest).getAwsProxyRequest().setPath(this.dispatchPath);
        assert (servletResponse instanceof HttpServletResponse) : servletResponse.getClass();
        this.lambdaContainerHandler.include((HttpServletRequest)servletRequest, (HttpServletResponse)servletResponse);
    }
}

