/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.model;

import com.amazonaws.serverless.proxy.model.ApiGatewayRequestContext;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class AwsProxyRequest {
    private String body;
    private String resource;
    private ApiGatewayRequestContext requestContext;
    private MultiValuedTreeMap<String, String> multiValueQueryStringParameters;
    private MultiValuedTreeMap<String, String> multiValueHeaders = new MultiValuedTreeMap(String.CASE_INSENSITIVE_ORDER);
    private Map<String, String> pathParameters;
    private String httpMethod;
    private Map<String, String> stageVariables;
    private String path;
    private boolean isBase64Encoded;

    public AwsProxyRequest() {
        this.multiValueQueryStringParameters = new MultiValuedTreeMap();
        this.pathParameters = new HashMap<String, String>();
        this.stageVariables = new HashMap<String, String>();
    }

    @JsonIgnore
    public String getQueryString() {
        StringBuilder params = new StringBuilder("");
        if (this.getMultiValueQueryStringParameters() == null) {
            return "";
        }
        for (String key : this.getMultiValueQueryStringParameters().keySet()) {
            Iterator iterator = this.getMultiValueQueryStringParameters().get(key).iterator();
            while (iterator.hasNext()) {
                String val = (String)iterator.next();
                String separator = params.length() == 0 ? "?" : "&";
                params.append(separator + key + "=" + val);
            }
        }
        return params.toString();
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public ApiGatewayRequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(ApiGatewayRequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public MultiValuedTreeMap<String, String> getMultiValueQueryStringParameters() {
        return this.multiValueQueryStringParameters;
    }

    public void setMultiValueQueryStringParameters(MultiValuedTreeMap<String, String> multiValueQueryStringParameters) {
        this.multiValueQueryStringParameters = multiValueQueryStringParameters;
    }

    public MultiValuedTreeMap<String, String> getMultiValueHeaders() {
        return this.multiValueHeaders;
    }

    public void setMultiValueHeaders(MultiValuedTreeMap<String, String> multiValueHeaders) {
        this.multiValueHeaders = multiValueHeaders;
    }

    public Map<String, String> getPathParameters() {
        return this.pathParameters;
    }

    public void setPathParameters(Map<String, String> pathParameters) {
        this.pathParameters = pathParameters;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public Map<String, String> getStageVariables() {
        return this.stageVariables;
    }

    public void setStageVariables(Map<String, String> stageVariables) {
        this.stageVariables = stageVariables;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public boolean isBase64Encoded() {
        return this.isBase64Encoded;
    }

    public void setIsBase64Encoded(boolean base64Encoded) {
        this.isBase64Encoded = base64Encoded;
    }
}

