/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.testutils;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.model.ApiGatewayAuthorizerContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestContext;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestIdentity;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.CognitoAuthorizerClaims;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.fasterxml.jackson.core.JsonProcessingException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.UUID;
import org.apache.commons.io.IOUtils;

public class AwsProxyRequestBuilder {
    private AwsProxyRequest request = new AwsProxyRequest();

    public AwsProxyRequestBuilder() {
        this(null, null);
    }

    public AwsProxyRequestBuilder(String path) {
        this(path, null);
    }

    public AwsProxyRequestBuilder(String path, String httpMethod) {
        this.request.setMultiValueHeaders(new MultiValuedTreeMap<String, String>(String.CASE_INSENSITIVE_ORDER));
        this.request.setHttpMethod(httpMethod);
        this.request.setPath(path);
        this.request.setMultiValueQueryStringParameters(new MultiValuedTreeMap<String, String>());
        this.request.setRequestContext(new ApiGatewayRequestContext());
        this.request.getRequestContext().setRequestId(UUID.randomUUID().toString());
        this.request.getRequestContext().setExtendedRequestId(UUID.randomUUID().toString());
        this.request.getRequestContext().setStage("test");
        this.request.getRequestContext().setProtocol("HTTP/1.1");
        this.request.getRequestContext().setRequestTimeEpoch(System.currentTimeMillis());
        ApiGatewayRequestIdentity identity = new ApiGatewayRequestIdentity();
        identity.setSourceIp("127.0.0.1");
        this.request.getRequestContext().setIdentity(identity);
    }

    public AwsProxyRequestBuilder stage(String stageName) {
        this.request.getRequestContext().setStage(stageName);
        return this;
    }

    public AwsProxyRequestBuilder method(String httpMethod) {
        this.request.setHttpMethod(httpMethod);
        return this;
    }

    public AwsProxyRequestBuilder path(String path) {
        this.request.setPath(path);
        return this;
    }

    public AwsProxyRequestBuilder json() {
        return this.header("Content-Type", "application/json");
    }

    public AwsProxyRequestBuilder form(String key, String value) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new MultiValuedTreeMap<String, String>(String.CASE_INSENSITIVE_ORDER));
        }
        this.request.getMultiValueHeaders().add("Content-Type", "application/x-www-form-urlencoded");
        String body = this.request.getBody();
        if (body == null) {
            body = "";
        }
        body = body + (body.equals("") ? "" : "&") + key + "=" + value;
        this.request.setBody(body);
        return this;
    }

    public AwsProxyRequestBuilder header(String key, String value) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new MultiValuedTreeMap<String, String>(String.CASE_INSENSITIVE_ORDER));
        }
        this.request.getMultiValueHeaders().add(key, value);
        return this;
    }

    public AwsProxyRequestBuilder queryString(String key, String value) {
        if (this.request.getMultiValueQueryStringParameters() == null) {
            this.request.setMultiValueQueryStringParameters(new MultiValuedTreeMap<String, String>());
        }
        this.request.getMultiValueQueryStringParameters().add(key, value);
        return this;
    }

    public AwsProxyRequestBuilder body(String body) {
        this.request.setBody(body);
        return this;
    }

    public AwsProxyRequestBuilder nullBody() {
        this.request.setBody(null);
        return this;
    }

    public AwsProxyRequestBuilder body(Object body) {
        if (this.request.getMultiValueHeaders() != null && this.request.getMultiValueHeaders().getFirst("Content-Type").equals("application/json")) {
            try {
                return this.body(LambdaContainerHandler.getObjectMapper().writeValueAsString(body));
            }
            catch (JsonProcessingException e) {
                throw new UnsupportedOperationException("Could not serialize object: " + e.getMessage());
            }
        }
        throw new UnsupportedOperationException("Unsupported content type in request");
    }

    public AwsProxyRequestBuilder binaryBody(InputStream is) throws IOException {
        this.request.setIsBase64Encoded(true);
        return this.body(Base64.getMimeEncoder().encodeToString(IOUtils.toByteArray((InputStream)is)));
    }

    public AwsProxyRequestBuilder authorizerPrincipal(String principal) {
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setPrincipalId(principal);
        if (this.request.getRequestContext().getAuthorizer().getClaims() == null) {
            this.request.getRequestContext().getAuthorizer().setClaims(new CognitoAuthorizerClaims());
        }
        this.request.getRequestContext().getAuthorizer().getClaims().setSubject(principal);
        return this;
    }

    public AwsProxyRequestBuilder authorizerContextValue(String key, String value) {
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setContextValue(key, value);
        return this;
    }

    public AwsProxyRequestBuilder cognitoUserPool(String identityId) {
        this.request.getRequestContext().getIdentity().setCognitoAuthenticationType("POOL");
        this.request.getRequestContext().getIdentity().setCognitoIdentityId(identityId);
        if (this.request.getRequestContext().getAuthorizer() == null) {
            this.request.getRequestContext().setAuthorizer(new ApiGatewayAuthorizerContext());
        }
        this.request.getRequestContext().getAuthorizer().setClaims(new CognitoAuthorizerClaims());
        this.request.getRequestContext().getAuthorizer().getClaims().setSubject(identityId);
        return this;
    }

    public AwsProxyRequestBuilder claim(String claim, String value) {
        this.request.getRequestContext().getAuthorizer().getClaims().setClaim(claim, value);
        return this;
    }

    public AwsProxyRequestBuilder cognitoIdentity(String identityId, String identityPoolId) {
        this.request.getRequestContext().getIdentity().setCognitoAuthenticationType("IDENTITY");
        this.request.getRequestContext().getIdentity().setCognitoIdentityId(identityId);
        this.request.getRequestContext().getIdentity().setCognitoIdentityPoolId(identityPoolId);
        return this;
    }

    public AwsProxyRequestBuilder cookie(String name, String value) {
        String cookies;
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new MultiValuedTreeMap<String, String>(String.CASE_INSENSITIVE_ORDER));
        }
        if ((cookies = this.request.getMultiValueHeaders().getFirst("Cookie")) == null) {
            cookies = "";
        }
        cookies = cookies + (cookies.equals("") ? "" : "; ") + name + "=" + value;
        this.request.getMultiValueHeaders().putSingle("Cookie", cookies);
        return this;
    }

    public AwsProxyRequestBuilder scheme(String scheme) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new MultiValuedTreeMap<String, String>(String.CASE_INSENSITIVE_ORDER));
        }
        this.request.getMultiValueHeaders().putSingle("CloudFront-Forwarded-Proto", scheme);
        return this;
    }

    public AwsProxyRequestBuilder serverName(String serverName) {
        if (this.request.getMultiValueHeaders() == null) {
            this.request.setMultiValueHeaders(new MultiValuedTreeMap<String, String>(String.CASE_INSENSITIVE_ORDER));
        }
        this.request.getMultiValueHeaders().putSingle("Host", serverName);
        return this;
    }

    public AwsProxyRequestBuilder userAgent(String agent) {
        if (this.request.getRequestContext() == null) {
            this.request.setRequestContext(new ApiGatewayRequestContext());
        }
        if (this.request.getRequestContext().getIdentity() == null) {
            this.request.getRequestContext().setIdentity(new ApiGatewayRequestIdentity());
        }
        this.request.getRequestContext().getIdentity().setUserAgent(agent);
        return this;
    }

    public AwsProxyRequestBuilder referer(String referer) {
        if (this.request.getRequestContext() == null) {
            this.request.setRequestContext(new ApiGatewayRequestContext());
        }
        if (this.request.getRequestContext().getIdentity() == null) {
            this.request.getRequestContext().setIdentity(new ApiGatewayRequestIdentity());
        }
        this.request.getRequestContext().getIdentity().setCaller(referer);
        return this;
    }

    public AwsProxyRequestBuilder fromJsonString(String jsonContent) throws IOException {
        this.request = (AwsProxyRequest)LambdaContainerHandler.getObjectMapper().readValue(jsonContent, AwsProxyRequest.class);
        return this;
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"})
    public AwsProxyRequestBuilder fromJsonPath(String filePath) throws IOException {
        this.request = (AwsProxyRequest)LambdaContainerHandler.getObjectMapper().readValue(new File(filePath), AwsProxyRequest.class);
        return this;
    }

    public AwsProxyRequest build() {
        return this.request;
    }

    public InputStream buildStream() {
        try {
            String requestJson = LambdaContainerHandler.getObjectMapper().writeValueAsString((Object)this.request);
            return new ByteArrayInputStream(requestJson.getBytes(StandardCharsets.UTF_8));
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }
}

