/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyRequestPart;
import com.amazonaws.serverless.proxy.internal.testutils.Timer;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;
import javax.servlet.AsyncContext;
import javax.servlet.ReadListener;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.NullInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsProxyHttpServletRequest
extends AwsHttpServletRequest {
    private AwsProxyRequest request;
    private SecurityContext securityContext;
    private Map<String, List<String>> urlEncodedFormParameters;
    private Map<String, Part> multipartFormParameters;
    private static Logger log = LoggerFactory.getLogger(AwsProxyHttpServletRequest.class);
    private ContainerConfig config;

    public AwsProxyHttpServletRequest(AwsProxyRequest awsProxyRequest, Context lambdaContext, SecurityContext awsSecurityContext) {
        this(awsProxyRequest, lambdaContext, awsSecurityContext, LambdaContainerHandler.getContainerConfig());
    }

    public AwsProxyHttpServletRequest(AwsProxyRequest awsProxyRequest, Context lambdaContext, SecurityContext awsSecurityContext, ContainerConfig config) {
        super(lambdaContext);
        this.request = awsProxyRequest;
        this.securityContext = awsSecurityContext;
        this.config = config;
    }

    public AwsProxyRequest getAwsProxyRequest() {
        return this.request;
    }

    public String getAuthType() {
        return this.securityContext.getAuthenticationScheme();
    }

    public Cookie[] getCookies() {
        if (this.request.getMultiValueHeaders() == null) {
            return new Cookie[0];
        }
        String cookieHeader = this.request.getMultiValueHeaders().getFirst("Cookie");
        if (cookieHeader == null) {
            return new Cookie[0];
        }
        return this.parseCookieHeaderValue(cookieHeader);
    }

    public long getDateHeader(String s) {
        if (this.request.getMultiValueHeaders() == null) {
            return -1L;
        }
        String dateString = this.request.getMultiValueHeaders().getFirst(s);
        if (dateString == null) {
            return -1L;
        }
        try {
            return Instant.from(ZonedDateTime.parse(dateString, dateFormatter)).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            log.warn("Invalid date header in request" + SecurityUtils.crlf(dateString));
            return -1L;
        }
    }

    public String getHeader(String s) {
        List<String> values = this.getHeaderValues(s);
        if (values == null || values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public Enumeration<String> getHeaders(String s) {
        if (this.request.getMultiValueHeaders() == null || this.request.getMultiValueHeaders().get(s) == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.request.getMultiValueHeaders().get(s));
    }

    public Enumeration<String> getHeaderNames() {
        if (this.request.getMultiValueHeaders() == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.request.getMultiValueHeaders().keySet());
    }

    public int getIntHeader(String s) {
        if (this.request.getMultiValueHeaders() == null) {
            return -1;
        }
        String headerValue = this.request.getMultiValueHeaders().getFirst(s);
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public String getMethod() {
        return this.request.getHttpMethod();
    }

    public String getPathInfo() {
        String pathInfo = this.cleanUri(this.request.getPath());
        return this.decodeRequestPath(pathInfo, LambdaContainerHandler.getContainerConfig());
    }

    public String getPathTranslated() {
        return null;
    }

    public String getContextPath() {
        String contextPath = "";
        if (this.config.isUseStageAsServletContext() && this.request.getRequestContext().getStage() != null) {
            log.debug("Using stage as context path");
            contextPath = this.cleanUri(this.request.getRequestContext().getStage());
        }
        if (this.config.getServiceBasePath() != null) {
            contextPath = contextPath + this.cleanUri(this.config.getServiceBasePath());
        }
        return contextPath;
    }

    public String getQueryString() {
        try {
            return this.generateQueryString(this.request.getMultiValueQueryStringParameters(), true, this.config.getUriEncoding());
        }
        catch (ServletException e) {
            log.error("Could not generate query string", (Throwable)e);
            return null;
        }
    }

    public String getRemoteUser() {
        return this.securityContext.getUserPrincipal().getName();
    }

    public boolean isUserInRole(String s) {
        return false;
    }

    public Principal getUserPrincipal() {
        return this.securityContext.getUserPrincipal();
    }

    public String getRequestURI() {
        return this.cleanUri(this.getContextPath()) + this.cleanUri(this.request.getPath());
    }

    public StringBuffer getRequestURL() {
        String url = "";
        url = url + this.getServerName();
        url = url + this.cleanUri(this.getContextPath());
        url = url + this.cleanUri(this.request.getPath());
        return new StringBuffer(this.getScheme() + "://" + url);
    }

    public String getServletPath() {
        return "";
    }

    public boolean authenticate(HttpServletResponse httpServletResponse) throws IOException, ServletException {
        throw new UnsupportedOperationException();
    }

    public void login(String s, String s1) throws ServletException {
        throw new UnsupportedOperationException();
    }

    public void logout() throws ServletException {
        throw new UnsupportedOperationException();
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        return this.getMultipartFormParametersMap().values();
    }

    public Part getPart(String s) throws IOException, ServletException {
        return this.getMultipartFormParametersMap().get(s);
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> aClass) throws IOException, ServletException {
        return null;
    }

    public String getCharacterEncoding() {
        String contentTypeHeader = this.request.getMultiValueHeaders().getFirst("Content-Type");
        if (contentTypeHeader == null) {
            return null;
        }
        String[] contentTypeValues = contentTypeHeader.split(";");
        if (contentTypeValues.length <= 1) {
            return null;
        }
        for (String contentTypeValue : contentTypeValues) {
            if (!contentTypeValue.trim().startsWith("charset")) continue;
            String[] encodingValues = contentTypeValue.split("=");
            if (encodingValues.length <= 1) {
                return null;
            }
            return encodingValues[1];
        }
        return null;
    }

    public void setCharacterEncoding(String s) throws UnsupportedEncodingException {
        String currentContentType = this.request.getMultiValueHeaders().getFirst("Content-Type");
        if (currentContentType == null || "".equals(currentContentType)) {
            log.error("Called set character encoding to " + SecurityUtils.crlf(s) + " on a request without a content type. Character encoding will not be set");
            return;
        }
        if (currentContentType.contains(";")) {
            String[] contentTypeValues = currentContentType.split(";");
            StringBuilder contentType = new StringBuilder(contentTypeValues[0]);
            for (int i = 1; i < contentTypeValues.length; ++i) {
                String contentTypeValue = contentTypeValues[i];
                String contentTypeString = "; " + contentTypeValue;
                if (contentTypeValue.trim().startsWith("charset")) {
                    contentTypeString = "; charset=" + s;
                }
                contentType.append(contentTypeString);
            }
            this.request.getMultiValueHeaders().putSingle("Content-Type", contentType.toString());
        } else {
            this.request.getMultiValueHeaders().putSingle("Content-Type", currentContentType + ";" + " " + "charset" + "=" + s);
        }
    }

    public int getContentLength() {
        String headerValue = this.request.getMultiValueHeaders().getFirst("Content-Length");
        if (headerValue == null) {
            return -1;
        }
        return Integer.parseInt(headerValue);
    }

    public long getContentLengthLong() {
        String headerValue = this.request.getMultiValueHeaders().getFirst("Content-Length");
        if (headerValue == null) {
            return -1L;
        }
        return Long.parseLong(headerValue);
    }

    public String getContentType() {
        String contentTypeHeader = this.request.getMultiValueHeaders().getFirst("Content-Type");
        if (contentTypeHeader == null || "".equals(contentTypeHeader.trim())) {
            return null;
        }
        return contentTypeHeader;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.request.getBody() == null) {
            return new AwsServletInputStream((InputStream)new NullInputStream(0L, false, false));
        }
        byte[] bodyBytes = null;
        if (this.request.isBase64Encoded()) {
            bodyBytes = Base64.getMimeDecoder().decode(this.request.getBody());
        } else {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = StandardCharsets.ISO_8859_1.name();
            }
            try {
                bodyBytes = this.request.getBody().getBytes(encoding);
            }
            catch (Exception e) {
                log.error("Could not read request with character encoding: " + SecurityUtils.crlf(encoding), (Throwable)e);
                bodyBytes = this.request.getBody().getBytes(StandardCharsets.ISO_8859_1.name());
            }
        }
        ByteArrayInputStream requestBodyStream = new ByteArrayInputStream(bodyBytes);
        return new AwsServletInputStream(requestBodyStream);
    }

    public String getParameter(String s) {
        String queryStringParameter = this.getFirstQueryParamValue(s, this.config.isQueryStringCaseSensitive());
        if (queryStringParameter != null) {
            return queryStringParameter;
        }
        String[] bodyParams = this.getFormBodyParameterCaseInsensitive(s);
        if (bodyParams == null || bodyParams.length == 0) {
            return null;
        }
        return bodyParams[0];
    }

    public Enumeration<String> getParameterNames() {
        if (this.request.getMultiValueQueryStringParameters() == null) {
            return Collections.emptyEnumeration();
        }
        return Collections.enumeration(this.request.getMultiValueQueryStringParameters().keySet());
    }

    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
    public String[] getParameterValues(String s) {
        String[] formBodyValues;
        ArrayList<String> values = new ArrayList<String>();
        String queryValue = this.getFirstQueryParamValue(s, this.config.isQueryStringCaseSensitive());
        if (queryValue != null) {
            values.add(queryValue);
        }
        if ((formBodyValues = this.getFormBodyParameterCaseInsensitive(s)) != null) {
            values.addAll(Arrays.asList(formBodyValues));
        }
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public Map<String, String[]> getParameterMap() {
        HashMap<String, String[]> output = new HashMap<String, String[]>();
        Map<String, List<String>> params = this.getFormUrlEncodedParametersMap();
        ((Stream)params.entrySet().stream().parallel()).forEach(e -> output.put((String)e.getKey(), ((List)e.getValue()).toArray(new String[0])));
        if (this.request.getMultiValueQueryStringParameters() != null) {
            ((Stream)this.request.getMultiValueQueryStringParameters().keySet().stream().parallel()).forEach(e -> {
                ArrayList<String> newValues = new ArrayList<String>();
                if (output.containsKey(e)) {
                    String[] values = (String[])output.get(e);
                    newValues.addAll(Arrays.asList(values));
                }
                newValues.add(this.getFirstQueryParamValue((String)e, this.config.isQueryStringCaseSensitive()));
                output.put((String)e, newValues.toArray(new String[0]));
            });
        }
        return output;
    }

    public String getProtocol() {
        return this.request.getRequestContext().getProtocol();
    }

    public String getScheme() {
        if (this.request.getMultiValueHeaders() == null) {
            return "https";
        }
        String cfScheme = this.request.getMultiValueHeaders().getFirst("CloudFront-Forwarded-Proto");
        if (cfScheme != null && SecurityUtils.isValidScheme(cfScheme)) {
            return cfScheme;
        }
        String gwScheme = this.request.getMultiValueHeaders().getFirst("X-Forwarded-Proto");
        if (gwScheme != null && SecurityUtils.isValidScheme(gwScheme)) {
            return gwScheme;
        }
        return "https";
    }

    @Override
    public String getServerName() {
        String hostHeader;
        String region = System.getenv("AWS_REGION");
        if (region == null) {
            region = "us-east-1";
        }
        if ((hostHeader = this.request.getMultiValueHeaders().getFirst("Host")) != null && SecurityUtils.isValidHost(hostHeader, this.request.getRequestContext().getApiId(), region)) {
            return hostHeader;
        }
        return this.request.getRequestContext().getApiId() + ".execute-api." + region + ".amazonaws.com";
    }

    @Override
    public int getServerPort() {
        if (this.request.getMultiValueHeaders() == null) {
            return 443;
        }
        String port = this.request.getMultiValueHeaders().getFirst("X-Forwarded-Port");
        if (SecurityUtils.isValidPort(port)) {
            return Integer.parseInt(port);
        }
        return 443;
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new StringReader(this.request.getBody()));
    }

    public String getRemoteAddr() {
        if (this.request.getRequestContext() == null || this.request.getRequestContext().getIdentity() == null) {
            return "127.0.0.1";
        }
        return this.request.getRequestContext().getIdentity().getSourceIp();
    }

    public String getRemoteHost() {
        return this.request.getMultiValueHeaders().getFirst("Host");
    }

    public Locale getLocale() {
        List<AwsHttpServletRequest.HeaderValue> values = this.parseHeaderValue(this.request.getMultiValueHeaders().getFirst("Accept-Language"), ",", ";");
        if (values.size() == 0) {
            return Locale.getDefault();
        }
        return new Locale(values.get(0).getValue());
    }

    public Enumeration<Locale> getLocales() {
        List<AwsHttpServletRequest.HeaderValue> values = this.parseHeaderValue(this.request.getMultiValueHeaders().getFirst("Accept-Language"), ",", ";");
        ArrayList<Locale> locales = new ArrayList<Locale>();
        if (values.size() == 0) {
            locales.add(Locale.getDefault());
        } else {
            for (AwsHttpServletRequest.HeaderValue locale : values) {
                locales.add(new Locale(locale.getValue()));
            }
        }
        return Collections.enumeration(locales);
    }

    public boolean isSecure() {
        return this.securityContext.isSecure();
    }

    public RequestDispatcher getRequestDispatcher(String s) {
        return this.getServletContext().getRequestDispatcher(s);
    }

    @Deprecated
    public String getRealPath(String s) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public AsyncContext startAsync() throws IllegalStateException {
        return null;
    }

    public AsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        return null;
    }

    private String[] getFormBodyParameterCaseInsensitive(String key) {
        List<String> values = this.getFormUrlEncodedParametersMap().get(key);
        if (values != null) {
            String[] valuesArray = new String[values.size()];
            valuesArray = values.toArray(valuesArray);
            return valuesArray;
        }
        return new String[0];
    }

    @SuppressFBWarnings(value={"FILE_UPLOAD_FILENAME", "WEAK_FILENAMEUTILS"})
    private Map<String, Part> getMultipartFormParametersMap() {
        if (this.multipartFormParameters != null) {
            return this.multipartFormParameters;
        }
        if (!ServletFileUpload.isMultipartContent((HttpServletRequest)this)) {
            this.multipartFormParameters = new HashMap<String, Part>();
            return this.multipartFormParameters;
        }
        Timer.start("SERVLET_REQUEST_GET_MULTIPART_PARAMS");
        this.multipartFormParameters = new TreeMap<String, Part>(String.CASE_INSENSITIVE_ORDER);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
        try {
            List items = upload.parseRequest((HttpServletRequest)this);
            for (FileItem item : items) {
                String fileName = FilenameUtils.getName((String)item.getName());
                AwsProxyRequestPart newPart = new AwsProxyRequestPart(item.get());
                newPart.setName(fileName);
                newPart.setSubmittedFileName(item.getFieldName());
                newPart.setContentType(item.getContentType());
                newPart.setSize(item.getSize());
                Iterator headerNamesIterator = item.getHeaders().getHeaderNames();
                while (headerNamesIterator.hasNext()) {
                    String headerName = (String)headerNamesIterator.next();
                    Iterator headerValuesIterator = item.getHeaders().getHeaders(headerName);
                    while (headerValuesIterator.hasNext()) {
                        newPart.addHeader(headerName, (String)headerValuesIterator.next());
                    }
                }
                this.multipartFormParameters.put(item.getFieldName(), newPart);
            }
        }
        catch (FileUploadException e) {
            Timer.stop("SERVLET_REQUEST_GET_MULTIPART_PARAMS");
            log.error("Could not read multipart upload file", (Throwable)e);
        }
        Timer.stop("SERVLET_REQUEST_GET_MULTIPART_PARAMS");
        return this.multipartFormParameters;
    }

    private String cleanUri(String uri) {
        String finalUri;
        String string = finalUri = uri == null ? "/" : uri;
        if (finalUri.equals("/")) {
            return finalUri;
        }
        if (!finalUri.startsWith("/")) {
            finalUri = "/" + finalUri;
        }
        if (finalUri.endsWith("/")) {
            finalUri = finalUri.substring(0, finalUri.length() - 1);
        }
        finalUri = finalUri.replaceAll("/+", "/");
        return finalUri;
    }

    private Map<String, List<String>> getFormUrlEncodedParametersMap() {
        if (this.urlEncodedFormParameters != null) {
            return this.urlEncodedFormParameters;
        }
        String contentType = this.getContentType();
        if (contentType == null) {
            this.urlEncodedFormParameters = new HashMap<String, List<String>>();
            return this.urlEncodedFormParameters;
        }
        if (!contentType.startsWith("application/x-www-form-urlencoded") || !this.getMethod().toLowerCase(Locale.ENGLISH).equals("post")) {
            this.urlEncodedFormParameters = new HashMap<String, List<String>>();
            return this.urlEncodedFormParameters;
        }
        Timer.start("SERVLET_REQUEST_GET_FORM_PARAMS");
        String rawBodyContent = null;
        try {
            rawBodyContent = IOUtils.toString((InputStream)this.getInputStream());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.urlEncodedFormParameters = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
        for (String parameter : rawBodyContent.split("&")) {
            String[] parameterKeyValue = parameter.split("=");
            if (parameterKeyValue.length < 2) continue;
            List<String> values = new ArrayList<String>();
            if (this.urlEncodedFormParameters.containsKey(parameterKeyValue[0])) {
                values = this.urlEncodedFormParameters.get(parameterKeyValue[0]);
            }
            values.add(AwsProxyHttpServletRequest.decodeValueIfEncoded(parameterKeyValue[1]));
            this.urlEncodedFormParameters.put(AwsProxyHttpServletRequest.decodeValueIfEncoded(parameterKeyValue[0]), values);
        }
        Timer.stop("SERVLET_REQUEST_GET_FORM_PARAMS");
        return this.urlEncodedFormParameters;
    }

    public static String decodeValueIfEncoded(String value) {
        if (value == null) {
            return null;
        }
        try {
            return URLDecoder.decode(value, LambdaContainerHandler.getContainerConfig().getUriEncoding());
        }
        catch (UnsupportedEncodingException e) {
            log.warn("Could not decode body content - proceeding as if it was already decoded", (Throwable)e);
            return value;
        }
    }

    private List<String> getHeaderValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        if ("referer".equals(key.toLowerCase(Locale.ENGLISH))) {
            values.add(this.request.getRequestContext().getIdentity().getCaller());
            return values;
        }
        if ("user-agent".equals(key.toLowerCase(Locale.ENGLISH))) {
            values.add(this.request.getRequestContext().getIdentity().getUserAgent());
            return values;
        }
        if (this.request.getMultiValueHeaders() == null) {
            return null;
        }
        return this.request.getMultiValueHeaders().get(key);
    }

    private String getFirstQueryParamValue(String key, boolean isCaseSensitive) {
        if (this.request.getMultiValueQueryStringParameters() != null) {
            if (isCaseSensitive) {
                return this.request.getMultiValueQueryStringParameters().getFirst(key);
            }
            for (String k : this.request.getMultiValueQueryStringParameters().keySet()) {
                if (!k.toLowerCase(Locale.getDefault()).equals(key.toLowerCase(Locale.getDefault()))) continue;
                return this.request.getMultiValueQueryStringParameters().getFirst(k);
            }
        }
        return null;
    }

    public String[] getQueryParamValues(String key, boolean isCaseSensitive) {
        if (this.request.getMultiValueQueryStringParameters() != null) {
            if (isCaseSensitive) {
                return this.request.getMultiValueQueryStringParameters().get(key).toArray(new String[0]);
            }
            for (String k : this.request.getMultiValueQueryStringParameters().keySet()) {
                if (!k.toLowerCase(Locale.getDefault()).equals(key.toLowerCase(Locale.getDefault()))) continue;
                return this.request.getMultiValueQueryStringParameters().get(k).toArray(new String[0]);
            }
        }
        return new String[0];
    }

    public static class AwsServletInputStream
    extends ServletInputStream {
        private InputStream bodyStream;
        private ReadListener listener;

        public AwsServletInputStream(InputStream body) {
            this.bodyStream = body;
        }

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            this.listener = readListener;
            try {
                this.listener.onDataAvailable();
            }
            catch (IOException e) {
                log.error("Data not available on input stream", (Throwable)e);
            }
        }

        public int read() throws IOException {
            int readByte = this.bodyStream.read();
            if (this.bodyStream.available() == 0 && this.listener != null) {
                this.listener.onAllDataRead();
            }
            return readByte;
        }
    }
}

