/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.ResponseWriter;
import com.amazonaws.serverless.proxy.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.servlet.ApacheCombinedServletLogFormatter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsFilterChainManager;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.servlet.FilterChainManager;
import java.io.IOException;
import javax.servlet.DispatcherType;
import javax.servlet.FilterChain;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsLambdaServletContainerHandler<RequestType, ResponseType, ContainerRequestType extends HttpServletRequest, ContainerResponseType extends HttpServletResponse>
extends LambdaContainerHandler<RequestType, ResponseType, ContainerRequestType, ContainerResponseType> {
    private Logger log = LoggerFactory.getLogger(AwsLambdaServletContainerHandler.class);
    private FilterChainManager<AwsServletContext> filterChainManager;
    private boolean startupExecuted;
    protected StartupHandler startupHandler;
    protected ServletContext servletContext;

    protected AwsLambdaServletContainerHandler(Class<RequestType> requestTypeClass, Class<ResponseType> responseTypeClass, RequestReader<RequestType, ContainerRequestType> requestReader, ResponseWriter<ContainerResponseType, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler) {
        super(requestTypeClass, responseTypeClass, requestReader, responseWriter, securityContextWriter, exceptionHandler);
        this.setLogFormatter(new ApacheCombinedServletLogFormatter());
        this.setServletContext(new AwsServletContext(this));
        this.startupExecuted = false;
    }

    public void forward(ContainerRequestType servletRequest, ContainerResponseType servletResponse) throws ServletException, IOException {
        try {
            this.handleRequest(servletRequest, this.getServletResponse(servletResponse), this.lambdaContext);
        }
        catch (Exception e) {
            this.log.error("Could not forward request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void include(ContainerRequestType servletRequest, ContainerResponseType servletResponse) throws ServletException, IOException {
        try {
            this.handleRequest(servletRequest, this.getServletResponse(servletResponse), this.lambdaContext);
        }
        catch (Exception e) {
            this.log.error("Could not include request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    private HttpServletResponse getServletResponse(ContainerResponseType resp) {
        if (HttpServletResponseWrapper.class.isAssignableFrom(resp.getClass())) {
            ServletResponse servletResp = ((HttpServletResponseWrapper)resp).getResponse();
            assert (servletResp instanceof HttpServletResponse) : servletResp.getClass();
            return (HttpServletResponse)servletResp;
        }
        if (HttpServletResponse.class.isAssignableFrom(resp.getClass())) {
            return resp;
        }
        throw new UnsupportedOperationException("Response type of " + resp.getClass().getName() + " is not supported");
    }

    public void onStartup(StartupHandler h) {
        this.startupHandler = h;
        this.startupHandler.onStartup(this.getServletContext());
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected void setServletContext(ServletContext context) {
        this.servletContext = context;
        this.filterChainManager = new AwsFilterChainManager((AwsServletContext)this.servletContext);
    }

    protected FilterChain getFilterChain(ContainerRequestType req, Servlet servlet) {
        return this.filterChainManager.getFilterChain((HttpServletRequest)req, servlet);
    }

    protected void doFilter(ContainerRequestType request, ContainerResponseType response, Servlet servlet) throws IOException, ServletException {
        FilterChain chain = this.getFilterChain(request, servlet);
        chain.doFilter(request, response);
        if (request.getDispatcherType() != DispatcherType.FORWARD && request.getDispatcherType() != DispatcherType.INCLUDE && !response.isCommitted()) {
            response.flushBuffer();
        }
    }

    public static interface StartupHandler {
        public void onStartup(ServletContext var1);
    }
}

