/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpSession;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestContext;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.serverless.proxy.model.MultiValuedTreeMap;
import com.amazonaws.services.lambda.runtime.Context;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsHttpServletRequest
implements HttpServletRequest {
    static final String HEADER_KEY_VALUE_SEPARATOR = "=";
    static final String HEADER_VALUE_SEPARATOR = ";";
    static final String HEADER_QUALIFIER_SEPARATOR = ",";
    static final String FORM_DATA_SEPARATOR = "&";
    static final DateTimeFormatter dateFormatter = DateTimeFormatter.RFC_1123_DATE_TIME;
    static final String ENCODING_VALUE_KEY = "charset";
    static final String CF_PROTOCOL_HEADER_NAME = "CloudFront-Forwarded-Proto";
    static final String PROTOCOL_HEADER_NAME = "X-Forwarded-Proto";
    static final String HOST_HEADER_NAME = "Host";
    static final String PORT_HEADER_NAME = "X-Forwarded-Port";
    private Context lambdaContext;
    private Map<String, Object> attributes;
    private ServletContext servletContext;
    private AwsHttpSession session;
    private String queryString;
    protected DispatcherType dispatcherType;
    private Logger log = LoggerFactory.getLogger(AwsHttpServletRequest.class);

    AwsHttpServletRequest(Context lambdaContext) {
        this.lambdaContext = lambdaContext;
        this.attributes = new HashMap<String, Object>();
    }

    public String getRequestedSessionId() {
        return null;
    }

    public HttpSession getSession(boolean b) {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        if (b && null == this.session) {
            ApiGatewayRequestContext requestContext = (ApiGatewayRequestContext)this.getAttribute("com.amazonaws.apigateway.request.context");
            this.session = new AwsHttpSession(requestContext.getRequestId());
        }
        return this.session;
    }

    public HttpSession getSession() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return this.session;
    }

    public String changeSessionId() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getServerName() {
        return "lambda.amazonaws.com";
    }

    public int getServerPort() {
        return 0;
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public String getLocalName() {
        return "lambda.amazonaws.com";
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public void setDispatcherType(DispatcherType type) {
        this.dispatcherType = type;
    }

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    protected Cookie[] parseCookieHeaderValue(String headerValue) {
        List<HeaderValue> parsedHeaders = this.parseHeaderValue(headerValue, HEADER_VALUE_SEPARATOR, HEADER_QUALIFIER_SEPARATOR);
        return (Cookie[])parsedHeaders.stream().filter(e -> e.getKey() != null).map(e -> new Cookie(SecurityUtils.crlf(e.getKey()), SecurityUtils.crlf(e.getValue()))).toArray(Cookie[]::new);
    }

    protected String generateQueryString(MultiValuedTreeMap<String, String> parameters, boolean encode, String encodeCharset) throws ServletException {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        if (this.queryString != null) {
            return this.queryString;
        }
        StringBuilder queryStringBuilder = new StringBuilder();
        try {
            for (String key : parameters.keySet()) {
                Iterator iterator = parameters.get(key).iterator();
                while (iterator.hasNext()) {
                    String val = (String)iterator.next();
                    queryStringBuilder.append(FORM_DATA_SEPARATOR);
                    if (encode) {
                        queryStringBuilder.append(URLEncoder.encode(key, encodeCharset));
                    } else {
                        queryStringBuilder.append(key);
                    }
                    queryStringBuilder.append(HEADER_KEY_VALUE_SEPARATOR);
                    if (encode) {
                        queryStringBuilder.append(URLEncoder.encode(val, encodeCharset));
                        continue;
                    }
                    queryStringBuilder.append(val);
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new ServletException("Invalid charset passed for query string encoding", (Throwable)e);
        }
        this.queryString = queryStringBuilder.toString();
        this.queryString = this.queryString.substring(1);
        return this.queryString;
    }

    protected List<HeaderValue> parseHeaderValue(String headerValue) {
        return this.parseHeaderValue(headerValue, HEADER_VALUE_SEPARATOR, HEADER_QUALIFIER_SEPARATOR);
    }

    protected List<HeaderValue> parseHeaderValue(String headerValue, String valueSeparator, String qualifierSeparator) {
        ArrayList<HeaderValue> values = new ArrayList<HeaderValue>();
        if (headerValue == null) {
            return values;
        }
        String[] stringArray = headerValue.split(valueSeparator);
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String v;
            String curValue = v = stringArray[i];
            float curPreference = 1.0f;
            HeaderValue newValue = new HeaderValue();
            newValue.setRawValue(v);
            for (String q : curValue.split(qualifierSeparator)) {
                if (q.contains(HEADER_KEY_VALUE_SEPARATOR)) {
                    String[] kv = q.split(HEADER_KEY_VALUE_SEPARATOR);
                    if (newValue.getValue() == null) {
                        newValue.setKey(kv[0].trim());
                        newValue.setValue(kv[1].trim());
                    } else if ("q".equals(kv[0].trim())) {
                        curPreference = Float.parseFloat(kv[1].trim());
                    } else {
                        newValue.addAttribute(kv[0].trim(), kv[1].trim());
                    }
                } else {
                    newValue.setValue(q.trim());
                }
                newValue.setPriority(curPreference);
            }
            values.add(newValue);
        }
        values.sort((first, second) -> {
            if (first.getPriority() - second.getPriority() < 0.001f) {
                return 0;
            }
            if (first.getPriority() < second.getPriority()) {
                return 1;
            }
            return -1;
        });
        return values;
    }

    protected String decodeRequestPath(String requestPath, ContainerConfig config) {
        try {
            return URLDecoder.decode(requestPath, config.getUriEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            this.log.error("Could not URL decode the request path, configured encoding not supported: {}", (Object)SecurityUtils.encode(config.getUriEncoding()));
            return requestPath;
        }
    }

    public static class HeaderValue {
        private String key;
        private String value;
        private String rawValue;
        private float priority;
        private Map<String, String> attributes = new HashMap<String, String>();

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getRawValue() {
            return this.rawValue;
        }

        public void setRawValue(String rawValue) {
            this.rawValue = rawValue;
        }

        public float getPriority() {
            return this.priority;
        }

        public void setPriority(float priority) {
            this.priority = priority;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public void addAttribute(String key, String value) {
            this.attributes.put(key, value);
        }

        public String getAttribute(String key) {
            return this.attributes.get(key);
        }
    }
}

