/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.ExceptionHandler;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.model.ErrorModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsProxyExceptionHandler
implements ExceptionHandler<AwsProxyResponse> {
    private Logger log = LoggerFactory.getLogger(AwsProxyExceptionHandler.class);
    static final String INTERNAL_SERVER_ERROR = "Internal Server Error";
    static final String GATEWAY_TIMEOUT_ERROR = "Gateway timeout";
    private static Map<String, String> headers = new HashMap<String, String>();

    @Override
    public AwsProxyResponse handle(Throwable ex) {
        this.log.error("Called exception handler for:", ex);
        ex.printStackTrace();
        if (ex instanceof InvalidRequestEventException) {
            return new AwsProxyResponse(500, headers, this.getErrorJson(INTERNAL_SERVER_ERROR));
        }
        return new AwsProxyResponse(502, headers, this.getErrorJson(GATEWAY_TIMEOUT_ERROR));
    }

    @Override
    public void handle(Throwable ex, OutputStream stream) throws IOException {
        AwsProxyResponse response = this.handle(ex);
        LambdaContainerHandler.getObjectMapper().writeValue(stream, (Object)response);
    }

    String getErrorJson(String message) {
        try {
            return LambdaContainerHandler.getObjectMapper().writeValueAsString((Object)new ErrorModel(message));
        }
        catch (JsonProcessingException e) {
            this.log.error("Could not produce error JSON", (Throwable)e);
            return "{ \"message\": \"" + message + "\" }";
        }
    }

    static {
        headers.put("Content-Type", "application/json");
    }
}

