/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.MultivaluedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncodingQueryStringParameterMap
extends MultivaluedHashMap<String, String> {
    private boolean isCaseSensitive;
    private String encoding;
    private static Logger log = LoggerFactory.getLogger(EncodingQueryStringParameterMap.class);
    private static final long serialVersionUID = 42L;

    public EncodingQueryStringParameterMap(boolean caseSensitive, String enc) {
        this.isCaseSensitive = caseSensitive;
        this.encoding = enc;
    }

    public void putAllMapEncoding(Map<String, String> parametersMap) {
        if (parametersMap == null) {
            return;
        }
        parametersMap.entrySet().stream().forEach(e -> {
            String key = (String)e.getKey();
            if (!this.isCaseSensitive) {
                key = key.toLowerCase(Locale.getDefault());
            }
            key = this.unescapeAndEncode(key);
            String value = this.unescapeAndEncode((String)e.getValue());
            this.putSingle(key, value);
        });
    }

    public void putAllMultiValuedMapEncoding(MultivaluedHashMap<String, String> parametersMap) {
        if (parametersMap == null) {
            return;
        }
        parametersMap.entrySet().stream().forEach(e -> {
            String key = (String)e.getKey();
            if (!this.isCaseSensitive) {
                key = key.toLowerCase(Locale.getDefault());
            }
            key = this.unescapeAndEncode(key);
            ArrayList newValueList = new ArrayList();
            ((List)e.getValue()).stream().forEach(v -> newValueList.add(this.unescapeAndEncode((String)v)));
            this.put(key, newValueList);
        });
    }

    private String unescapeAndEncode(String value) {
        try {
            return URLEncoder.encode(value, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            log.error("Could not url encode parameter value: " + SecurityUtils.crlf(value), (Throwable)e);
            return null;
        }
    }
}

