/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.SecurityUtils;
import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpSession;
import com.amazonaws.serverless.proxy.internal.servlet.EncodingQueryStringParameterMap;
import com.amazonaws.serverless.proxy.model.ApiGatewayRequestContext;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.time.format.DateTimeFormatter;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsHttpServletRequest
implements HttpServletRequest {
    static final String HEADER_KEY_VALUE_SEPARATOR = "=";
    static final String HEADER_VALUE_SEPARATOR = ";";
    static final String FORM_DATA_SEPARATOR = "&";
    static final String DEFAULT_CHARACTER_ENCODING = "UTF-8";
    static final DateTimeFormatter dateFormatter = DateTimeFormatter.RFC_1123_DATE_TIME;
    static final String ENCODING_VALUE_KEY = "charset";
    static final String CF_PROTOCOL_HEADER_NAME = "CloudFront-Forwarded-Proto";
    static final String PROTOCOL_HEADER_NAME = "X-Forwarded-Proto";
    static final String HOST_HEADER_NAME = "Host";
    static final String PORT_HEADER_NAME = "X-Forwarded-Port";
    private Context lambdaContext;
    private Map<String, Object> attributes;
    private ServletContext servletContext;
    private AwsHttpSession session;
    private String queryString;
    protected DispatcherType dispatcherType;
    private Logger log = LoggerFactory.getLogger(AwsHttpServletRequest.class);

    AwsHttpServletRequest(Context lambdaContext) {
        this.lambdaContext = lambdaContext;
        this.attributes = new HashMap<String, Object>();
    }

    public String getRequestedSessionId() {
        return null;
    }

    public HttpSession getSession(boolean b) {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        if (b && null == this.session) {
            ApiGatewayRequestContext requestContext = (ApiGatewayRequestContext)this.getAttribute("com.amazonaws.apigateway.request.context");
            this.session = new AwsHttpSession(requestContext.getRequestId());
        }
        return this.session;
    }

    public HttpSession getSession() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return this.session;
    }

    public String changeSessionId() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return null;
    }

    public boolean isRequestedSessionIdValid() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    @Deprecated
    public boolean isRequestedSessionIdFromUrl() {
        this.log.debug("Trying to access session. Lambda functions are stateless and should not rely on the session");
        return false;
    }

    public Object getAttribute(String s) {
        return this.attributes.get(s);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getServerName() {
        return "lambda.amazonaws.com";
    }

    public int getServerPort() {
        return 0;
    }

    public void setAttribute(String s, Object o) {
        this.attributes.put(s, o);
    }

    public void removeAttribute(String s) {
        this.attributes.remove(s);
    }

    public String getLocalName() {
        return "lambda.amazonaws.com";
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isAsyncStarted() {
        return false;
    }

    public boolean isAsyncSupported() {
        return false;
    }

    public AsyncContext getAsyncContext() {
        return null;
    }

    public DispatcherType getDispatcherType() {
        return DispatcherType.REQUEST;
    }

    public void setDispatcherType(DispatcherType type) {
        this.dispatcherType = type;
    }

    public void setServletContext(ServletContext context) {
        this.servletContext = context;
    }

    protected Cookie[] parseCookieHeaderValue(String headerValue) {
        List<Map.Entry<String, String>> parsedHeaders = this.parseHeaderValue(headerValue);
        return (Cookie[])parsedHeaders.stream().filter(e -> e.getKey() != null).map(e -> new Cookie(SecurityUtils.crlf((String)e.getKey()), SecurityUtils.crlf((String)e.getValue()))).toArray(Cookie[]::new);
    }

    protected String generateQueryString(EncodingQueryStringParameterMap parameters) {
        if (parameters == null || parameters.size() == 0) {
            return null;
        }
        if (this.queryString != null) {
            return this.queryString;
        }
        StringBuilder queryStringBuilder = new StringBuilder();
        parameters.keySet().stream().forEach(k -> parameters.get(k).stream().forEach(v -> {
            queryStringBuilder.append(FORM_DATA_SEPARATOR);
            queryStringBuilder.append((String)k);
            queryStringBuilder.append(HEADER_KEY_VALUE_SEPARATOR);
            queryStringBuilder.append((String)v);
        }));
        this.queryString = queryStringBuilder.toString();
        this.queryString = this.queryString.substring(1);
        return this.queryString;
    }

    protected List<Map.Entry<String, String>> parseHeaderValue(String headerValue) {
        ArrayList<Map.Entry<String, String>> values = new ArrayList<Map.Entry<String, String>>();
        if (headerValue == null) {
            return values;
        }
        for (String kv : headerValue.split(HEADER_VALUE_SEPARATOR)) {
            String[] kvSplit = kv.split(HEADER_KEY_VALUE_SEPARATOR);
            if (kvSplit.length != 2) {
                values.add(new AbstractMap.SimpleEntry<Object, String>(null, kv.trim()));
                continue;
            }
            values.add(new AbstractMap.SimpleEntry<String, String>(kvSplit[0].trim(), kvSplit[1].trim()));
        }
        return values;
    }

    protected String decodeRequestPath(String requestPath, ContainerConfig config) {
        try {
            return URLDecoder.decode(requestPath, config.getUriEncoding());
        }
        catch (UnsupportedEncodingException ex) {
            this.log.error("Could not URL decode the request path, configured encoding not supported: {}", (Object)SecurityUtils.encode(config.getUriEncoding()));
            return requestPath;
        }
    }
}

