/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.RequestReader;
import com.amazonaws.serverless.proxy.internal.servlet.AwsProxyHttpServletRequest;
import com.amazonaws.serverless.proxy.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.model.ContainerConfig;
import com.amazonaws.services.lambda.runtime.Context;
import javax.ws.rs.core.SecurityContext;

public class AwsProxyHttpServletRequestReader
extends RequestReader<AwsProxyRequest, AwsProxyHttpServletRequest> {
    @Override
    public AwsProxyHttpServletRequest readRequest(AwsProxyRequest request, SecurityContext securityContext, Context lambdaContext, ContainerConfig config) throws InvalidRequestEventException {
        request.setPath(this.stripBasePath(request.getPath(), config));
        AwsProxyHttpServletRequest servletRequest = new AwsProxyHttpServletRequest(request, lambdaContext, securityContext, config);
        servletRequest.setAttribute("com.amazonaws.apigateway.request.context", request.getRequestContext());
        servletRequest.setAttribute("com.amazonaws.apigateway.stage.variables", request.getStageVariables());
        servletRequest.setAttribute("com.amazonaws.lambda.context", lambdaContext);
        servletRequest.setAttribute("com.amazonaws.serverless.jaxrs.securityContext", securityContext);
        return servletRequest;
    }

    @Override
    protected Class<? extends AwsProxyRequest> getRequestClass() {
        return AwsProxyRequest.class;
    }
}

