/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.FilterHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChainHolder
implements FilterChain {
    private List<FilterHolder> filters;
    int currentFilter;
    private Logger log = LoggerFactory.getLogger(FilterChainHolder.class);

    FilterChainHolder() {
        this(new ArrayList<FilterHolder>());
    }

    FilterChainHolder(List<FilterHolder> allFilters) {
        this.filters = allFilters;
        this.resetHolder();
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
        ++this.currentFilter;
        if (this.currentFilter <= this.filters.size() - 1) {
            FilterHolder holder = this.filters.get(this.currentFilter);
            if (!holder.isFilterInitialized()) {
                holder.init();
            }
            this.log.debug("Starting {} {} : filter {}-{} {}", new Object[]{servletRequest.getDispatcherType(), ((HttpServletRequest)servletRequest).getRequestURI(), this.currentFilter, holder.getFilterName(), holder.getFilter()});
            holder.getFilter().doFilter(servletRequest, servletResponse, (FilterChain)this);
            this.log.debug("Executed {} {} : filter {}-{} {}", new Object[]{servletRequest.getDispatcherType(), ((HttpServletRequest)servletRequest).getRequestURI(), this.currentFilter, holder.getFilterName(), holder.getFilter()});
        }
        if (!servletResponse.isCommitted()) {
            servletResponse.flushBuffer();
        }
    }

    void addFilter(FilterHolder newFilter) {
        this.filters.add(newFilter);
    }

    int filterCount() {
        if (this.filters == null) {
            return 0;
        }
        return this.filters.size();
    }

    FilterHolder getFilter(int idx) {
        if (this.filters == null) {
            return null;
        }
        return this.filters.get(idx);
    }

    public List<FilterHolder> getFilters() {
        return this.filters;
    }

    private void resetHolder() {
        this.currentFilter = -1;
    }

    public String toString() {
        return "filters=" + this.filters;
    }
}

