/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.model;

public class ContainerConfig {
    public static final String DEFAULT_URI_ENCODING = "UTF-8";
    private String serviceBasePath;
    private boolean stripBasePath;
    private String uriEncoding;
    private boolean consolidateSetCookieHeaders;

    public static ContainerConfig defaultConfig() {
        ContainerConfig configuration = new ContainerConfig();
        configuration.setStripBasePath(false);
        configuration.setUriEncoding(DEFAULT_URI_ENCODING);
        configuration.setConsolidateSetCookieHeaders(true);
        return configuration;
    }

    public String getServiceBasePath() {
        return this.serviceBasePath;
    }

    public void setServiceBasePath(String serviceBasePath) {
        String finalBasePath = serviceBasePath;
        if (!finalBasePath.startsWith("/")) {
            finalBasePath = "/" + serviceBasePath;
        }
        if (finalBasePath.endsWith("/")) {
            finalBasePath = finalBasePath.substring(0, finalBasePath.length() - 1);
        }
        this.serviceBasePath = finalBasePath;
    }

    public boolean isStripBasePath() {
        return this.stripBasePath;
    }

    public void setStripBasePath(boolean stripBasePath) {
        this.stripBasePath = stripBasePath;
    }

    public String getUriEncoding() {
        return this.uriEncoding;
    }

    public void setUriEncoding(String uriEncoding) {
        this.uriEncoding = uriEncoding;
    }

    public boolean isConsolidateSetCookieHeaders() {
        return this.consolidateSetCookieHeaders;
    }

    public void setConsolidateSetCookieHeaders(boolean consolidateSetCookieHeaders) {
        this.consolidateSetCookieHeaders = consolidateSetCookieHeaders;
    }
}

