/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.jaxrs;

import com.amazonaws.serverless.proxy.internal.model.AwsProxyRequest;
import com.amazonaws.serverless.proxy.internal.model.CognitoAuthorizerClaims;
import com.amazonaws.services.lambda.runtime.Context;
import java.security.Principal;
import javax.ws.rs.core.SecurityContext;

public class AwsProxySecurityContext
implements SecurityContext {
    private static final String AUTH_SCHEME_CUSTOM = "CUSTOM_AUTHORIZER";
    private static final String AUTH_SCHEME_COGNITO_POOL = "COGNITO_USER_POOL";
    private static final String AUTH_SCHEME_AWS_IAM = "AWS_IAM";
    protected Context lambdaContext;
    protected AwsProxyRequest event;

    public AwsProxySecurityContext(Context lambdaContext, AwsProxyRequest event) {
        this.lambdaContext = lambdaContext;
        this.event = event;
    }

    public Principal getUserPrincipal() {
        if (this.getAuthenticationScheme() == null) {
            return () -> null;
        }
        if (this.getAuthenticationScheme().equals(AUTH_SCHEME_CUSTOM) || this.getAuthenticationScheme().equals(AUTH_SCHEME_AWS_IAM)) {
            return () -> {
                if (this.getAuthenticationScheme().equals(AUTH_SCHEME_CUSTOM)) {
                    return this.event.getRequestContext().getAuthorizer().getPrincipalId();
                }
                if (this.getAuthenticationScheme().equals(AUTH_SCHEME_AWS_IAM)) {
                    if (this.event.getRequestContext().getIdentity().getCognitoIdentityId() != null) {
                        return this.event.getRequestContext().getIdentity().getCognitoIdentityId();
                    }
                    return this.event.getRequestContext().getIdentity().getUserArn();
                }
                return null;
            };
        }
        if (this.getAuthenticationScheme().equals(AUTH_SCHEME_COGNITO_POOL)) {
            return new CognitoUserPoolPrincipal(this.event.getRequestContext().getAuthorizer().getClaims());
        }
        throw new RuntimeException("Cannot recognize authorization scheme in event");
    }

    public boolean isUserInRole(String role) {
        return role.equals(this.event.getRequestContext().getIdentity().getUserArn());
    }

    public boolean isSecure() {
        return this.getAuthenticationScheme() != null;
    }

    public String getAuthenticationScheme() {
        if (this.event.getRequestContext().getAuthorizer() != null && this.event.getRequestContext().getAuthorizer().getClaims() != null && this.event.getRequestContext().getAuthorizer().getClaims().getSubject() != null) {
            return AUTH_SCHEME_COGNITO_POOL;
        }
        if (this.event.getRequestContext().getAuthorizer() != null) {
            return AUTH_SCHEME_CUSTOM;
        }
        if (this.event.getRequestContext().getIdentity().getAccessKey() != null) {
            return AUTH_SCHEME_AWS_IAM;
        }
        return null;
    }

    public class CognitoUserPoolPrincipal
    implements Principal {
        private CognitoAuthorizerClaims claims;

        CognitoUserPoolPrincipal(CognitoAuthorizerClaims c) {
            this.claims = c;
        }

        @Override
        public String getName() {
            return this.claims.getSubject();
        }

        public CognitoAuthorizerClaims getClaims() {
            return this.claims;
        }
    }
}

