/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.FilterChainHolder;
import com.amazonaws.serverless.proxy.internal.servlet.FilterHolder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public abstract class FilterChainManager<ServletContextType extends ServletContext> {
    static final String PATH_PART_SEPARATOR = "/";
    private Map<TargetCacheKey, List<FilterHolder>> filterCache = Collections.synchronizedMap(new HashMap());
    private int filtersSize = -1;
    protected ServletContextType servletContext;

    FilterChainManager(ServletContextType context) {
        this.servletContext = context;
    }

    protected abstract Map<String, FilterHolder> getFilterHolders();

    FilterChainHolder getFilterChain(HttpServletRequest request) {
        String targetPath = request.getServletPath();
        DispatcherType type = request.getDispatcherType();
        if (this.getFilterHolders().size() == this.filtersSize && this.getFilterChainCache(type, targetPath) != null) {
            return this.getFilterChainCache(type, targetPath);
        }
        FilterChainHolder chainHolder = new FilterChainHolder();
        Map<String, FilterHolder> registrations = this.getFilterHolders();
        if (registrations == null || registrations.size() == 0) {
            return chainHolder;
        }
        for (String name : registrations.keySet()) {
            FilterHolder holder = registrations.get(name);
            if (holder.getRegistration().getDispatcherTypes().size() > 0 && !holder.getRegistration().getDispatcherTypes().contains(type)) continue;
            for (String path : holder.getRegistration().getUrlPatternMappings()) {
                if (!this.pathMatches(targetPath, path)) continue;
                chainHolder.addFilter(holder);
            }
        }
        this.putFilterChainCache(type, targetPath, chainHolder);
        if (this.filtersSize != registrations.size()) {
            this.filtersSize = registrations.size();
        }
        return chainHolder;
    }

    private FilterChainHolder getFilterChainCache(DispatcherType type, String targetPath) {
        TargetCacheKey key = new TargetCacheKey();
        key.setDispatcherType(type);
        key.setTargetPath(targetPath);
        if (!this.filterCache.containsKey(key)) {
            return null;
        }
        return new FilterChainHolder(this.filterCache.get(key));
    }

    private void putFilterChainCache(DispatcherType type, String targetPath, FilterChainHolder holder) {
        TargetCacheKey key = new TargetCacheKey();
        key.setDispatcherType(type);
        key.setTargetPath(targetPath);
        if (key.hashCode() == -1) {
            return;
        }
        this.filterCache.put(key, holder.getFilters());
    }

    boolean pathMatches(String target, String mapping) {
        if (target.toLowerCase().equals(mapping.toLowerCase())) {
            return true;
        }
        String finalTarget = target;
        String finalMapping = mapping;
        if (target.startsWith(PATH_PART_SEPARATOR)) {
            finalTarget = target.replaceFirst(PATH_PART_SEPARATOR, "");
        }
        if (mapping.startsWith(PATH_PART_SEPARATOR)) {
            finalMapping = mapping.replaceFirst(PATH_PART_SEPARATOR, "");
        }
        String[] targetParts = finalTarget.split(PATH_PART_SEPARATOR);
        String[] mappingParts = finalMapping.split(PATH_PART_SEPARATOR);
        if (mappingParts.length == 1 && mappingParts[0].equals("*")) {
            return true;
        }
        for (int i = 0; i < targetParts.length; ++i) {
            if (mappingParts.length < i + 1) {
                return false;
            }
            if (targetParts[i].equals(mappingParts[i])) continue;
            if (mappingParts[i].equals("*")) break;
            return false;
        }
        return true;
    }

    protected static class TargetCacheKey {
        private String targetPath;
        private DispatcherType dispatcherType;

        protected TargetCacheKey() {
        }

        public int hashCode() {
            String hashString;
            String hashPath = this.targetPath;
            if (this.targetPath == null) {
                hashPath = FilterChainManager.PATH_PART_SEPARATOR;
            }
            String hashDispatcher = "";
            if (this.dispatcherType != null) {
                hashDispatcher = this.dispatcherType.name();
            }
            if ((hashString = hashPath.trim()).endsWith(FilterChainManager.PATH_PART_SEPARATOR)) {
                hashString = hashString.substring(0, hashString.length() - 1);
            }
            if (!hashString.startsWith(FilterChainManager.PATH_PART_SEPARATOR)) {
                hashString = FilterChainManager.PATH_PART_SEPARATOR + hashString;
            }
            hashString = hashString + ":" + hashDispatcher;
            return hashString.hashCode();
        }

        public boolean equals(Object key) {
            return key.getClass().isAssignableFrom(TargetCacheKey.class) && this.hashCode() == key.hashCode();
        }

        void setTargetPath(String targetPath) {
            this.targetPath = targetPath;
        }

        void setDispatcherType(DispatcherType dispatcherType) {
            this.dispatcherType = dispatcherType;
        }
    }
}

