/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.ExceptionHandler;
import com.amazonaws.serverless.proxy.internal.LambdaContainerHandler;
import com.amazonaws.serverless.proxy.internal.RequestReader;
import com.amazonaws.serverless.proxy.internal.ResponseWriter;
import com.amazonaws.serverless.proxy.internal.SecurityContextWriter;
import com.amazonaws.serverless.proxy.internal.servlet.AwsFilterChainManager;
import com.amazonaws.serverless.proxy.internal.servlet.AwsServletContext;
import com.amazonaws.serverless.proxy.internal.servlet.FilterChainHolder;
import com.amazonaws.serverless.proxy.internal.servlet.FilterChainManager;
import com.amazonaws.services.lambda.runtime.Context;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AwsLambdaServletContainerHandler<RequestType, ResponseType, ContainerRequestType extends HttpServletRequest, ContainerResponseType extends HttpServletResponse>
extends LambdaContainerHandler<RequestType, ResponseType, ContainerRequestType, ContainerResponseType> {
    protected ServletContext servletContext;
    private Logger log = LoggerFactory.getLogger(AwsLambdaServletContainerHandler.class);
    protected StartupHandler startupHandler;
    private FilterChainManager<AwsServletContext> filterChainManager;

    protected AwsLambdaServletContainerHandler(RequestReader<RequestType, ContainerRequestType> requestReader, ResponseWriter<ContainerResponseType, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler) {
        super(requestReader, responseWriter, securityContextWriter, exceptionHandler);
    }

    public void forward(ContainerRequestType servletRequest, ContainerResponseType servletResponse) throws ServletException, IOException {
        try {
            this.handleRequest(servletRequest, servletResponse, this.lambdaContext);
        }
        catch (Exception e) {
            this.log.error("Could not forward request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void include(ContainerRequestType servletRequest, ContainerResponseType servletResponse) throws ServletException, IOException {
        try {
            this.handleRequest(servletRequest, servletResponse, this.lambdaContext);
        }
        catch (Exception e) {
            this.log.error("Could not include request", (Throwable)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void onStartup(StartupHandler h) {
        this.startupHandler = h;
    }

    @Override
    protected void handleRequest(ContainerRequestType containerRequest, ContainerResponseType containerResponse, Context lambdaContext) throws Exception {
        if (this.getServletContext() == null) {
            this.setServletContext(new AwsServletContext(this));
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    protected void setServletContext(ServletContext context) {
        this.servletContext = context;
        this.filterChainManager = new AwsFilterChainManager((AwsServletContext)context);
    }

    protected void doFilter(ContainerRequestType request, ContainerResponseType response) throws IOException, ServletException {
        FilterChainHolder chain = this.filterChainManager.getFilterChain((HttpServletRequest)request);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public static interface StartupHandler {
        public void onStartup(ServletContext var1);
    }
}

