/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal.servlet;

import com.amazonaws.serverless.proxy.internal.servlet.AwsHttpServletRequest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.CountDownLatch;
import javax.servlet.ServletOutputStream;
import javax.servlet.WriteListener;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MultivaluedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AwsHttpServletResponse
implements HttpServletResponse {
    static final String HEADER_DATE_PATTERN = "EEE, d MMM yyyy HH:mm:ss z";
    static final String COOKIE_DEFAULT_TIME_ZONE = "GMT";
    private MultivaluedHashMap<String, String> headers = new MultivaluedHashMap();
    private int statusCode;
    private String statusMessage;
    private String responseBody;
    private ByteArrayOutputStream bodyOutputStream = new ByteArrayOutputStream();
    private CountDownLatch writersCountDownLatch;
    private AwsHttpServletRequest request;
    private boolean isCommitted = false;
    private Logger log = LoggerFactory.getLogger(AwsHttpServletResponse.class);

    public AwsHttpServletResponse(AwsHttpServletRequest req, CountDownLatch latch) {
        this.writersCountDownLatch = latch;
        this.request = req;
    }

    public void addCookie(Cookie cookie) {
        String cookieData = cookie.getName() + "=" + cookie.getValue();
        if (cookie.getPath() != null) {
            cookieData = cookieData + "; Path=" + cookie.getPath();
        }
        if (cookie.getSecure()) {
            cookieData = cookieData + "; Secure";
        }
        if (cookie.isHttpOnly()) {
            cookieData = cookieData + "; HttpOnly";
        }
        if (cookie.getDomain() != null && !"".equals(cookie.getDomain().trim())) {
            cookieData = cookieData + "; Domain=" + cookie.getDomain();
        }
        cookieData = cookieData + "; Max-Age=" + cookie.getMaxAge();
        TimeZone gmtTimeZone = TimeZone.getTimeZone(COOKIE_DEFAULT_TIME_ZONE);
        Calendar currentTimestamp = Calendar.getInstance(gmtTimeZone);
        currentTimestamp.add(13, cookie.getMaxAge());
        SimpleDateFormat cookieDateFormatter = new SimpleDateFormat(HEADER_DATE_PATTERN);
        cookieDateFormatter.setTimeZone(gmtTimeZone);
        cookieData = cookieData + "; Expires=" + cookieDateFormatter.format(currentTimestamp.getTime());
        this.setHeader("Set-Cookie", cookieData, false);
    }

    public boolean containsHeader(String s) {
        return this.headers.containsKey((Object)s);
    }

    public String encodeURL(String s) {
        return s;
    }

    public String encodeRedirectURL(String s) {
        return s;
    }

    @Deprecated
    public String encodeUrl(String s) {
        return this.encodeURL(s);
    }

    @Deprecated
    public String encodeRedirectUrl(String s) {
        return this.encodeRedirectURL(s);
    }

    public void sendError(int i, String s) throws IOException {
        this.setStatus(i, s);
        this.flushBuffer();
    }

    public void sendError(int i) throws IOException {
        this.setStatus(i);
        this.flushBuffer();
    }

    public void sendRedirect(String s) throws IOException {
        this.setStatus(301);
        this.addHeader("Location", s);
        this.flushBuffer();
    }

    public void setDateHeader(String s, long l) {
        SimpleDateFormat sdf = new SimpleDateFormat(HEADER_DATE_PATTERN);
        Date responseDate = new Date();
        responseDate.setTime(l);
        this.setHeader(s, sdf.format(responseDate), true);
    }

    public void addDateHeader(String s, long l) {
        SimpleDateFormat sdf = new SimpleDateFormat(HEADER_DATE_PATTERN);
        Date responseDate = new Date();
        responseDate.setTime(l);
        this.setHeader(s, sdf.format(responseDate), false);
    }

    public void setHeader(String s, String s1) {
        this.setHeader(s, s1, true);
    }

    public void addHeader(String s, String s1) {
        this.setHeader(s, s1, false);
    }

    public void setIntHeader(String s, int i) {
        this.setHeader(s, "" + i, true);
    }

    public void addIntHeader(String s, int i) {
        this.setHeader(s, "" + i, false);
    }

    public void setStatus(int i) {
        this.statusCode = i;
    }

    @Deprecated
    public void setStatus(int i, String s) {
        this.statusCode = i;
        this.statusMessage = s;
    }

    public int getStatus() {
        return this.statusCode;
    }

    public String getHeader(String s) {
        return (String)this.headers.getFirst((Object)s);
    }

    public Collection<String> getHeaders(String s) {
        if (this.headers.get((Object)s) == null) {
            return new ArrayList<String>();
        }
        return this.headers.get((Object)s);
    }

    public Collection<String> getHeaderNames() {
        return this.headers.keySet();
    }

    public String getCharacterEncoding() {
        return (String)this.headers.getFirst((Object)"Content-Encoding");
    }

    public String getContentType() {
        return (String)this.headers.getFirst((Object)"Content-Type");
    }

    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream(){
            private WriteListener listener;

            public boolean isReady() {
                return true;
            }

            public void setWriteListener(WriteListener writeListener) {
                if (writeListener != null) {
                    try {
                        writeListener.onWritePossible();
                    }
                    catch (IOException e) {
                        AwsHttpServletResponse.this.log.error("Output stream is not writable", (Throwable)e);
                    }
                    this.listener = writeListener;
                }
            }

            public void write(int b) throws IOException {
                try {
                    AwsHttpServletResponse.this.bodyOutputStream.write(b);
                }
                catch (Exception e) {
                    AwsHttpServletResponse.this.log.error("Cannot write to output stream", (Throwable)e);
                    this.listener.onError((Throwable)e);
                }
            }

            public void close() throws IOException {
                super.close();
                AwsHttpServletResponse.this.flushBuffer();
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        return new PrintWriter(this.bodyOutputStream);
    }

    public void setCharacterEncoding(String s) {
        this.setHeader("Content-Encoding", s, true);
    }

    public void setContentLength(int i) {
        this.setHeader("Content-Length", "" + i, true);
    }

    public void setContentLengthLong(long l) {
        this.setHeader("Content-Length", "" + l, true);
    }

    public void setContentType(String s) {
        this.setHeader("Content-Type", s, true);
    }

    public void setBufferSize(int i) {
        this.bodyOutputStream = new ByteArrayOutputStream(i);
    }

    public int getBufferSize() {
        return this.bodyOutputStream.size();
    }

    public void flushBuffer() throws IOException {
        this.responseBody = new String(this.bodyOutputStream.toByteArray());
        this.isCommitted = true;
        this.writersCountDownLatch.countDown();
    }

    public void resetBuffer() {
        this.bodyOutputStream = new ByteArrayOutputStream();
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void reset() {
        this.headers = new MultivaluedHashMap();
        this.responseBody = null;
        this.bodyOutputStream = new ByteArrayOutputStream();
    }

    public void setLocale(Locale locale) {
        this.setHeader("Content-Language", locale.getLanguage(), true);
    }

    public Locale getLocale() {
        return new Locale(this.getHeader("Content-Language"));
    }

    String getAwsResponseBodyString() {
        return this.responseBody;
    }

    byte[] getAwsResponseBodyBytes() {
        if (this.bodyOutputStream != null) {
            return this.bodyOutputStream.toByteArray();
        }
        return new byte[0];
    }

    Map<String, String> getAwsResponseHeaders() {
        HashMap<String, String> responseHeaders = new HashMap<String, String>();
        for (String header : this.getHeaderNames()) {
            responseHeaders.put(header, (String)this.headers.getFirst((Object)header));
        }
        return responseHeaders;
    }

    private void setHeader(String key, String value, boolean overwrite) {
        ArrayList<String> values = this.headers.get((Object)key);
        if (values == null || overwrite) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.headers.put((Object)key, values);
    }
}

