/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal;

import com.amazonaws.serverless.proxy.internal.ExceptionHandler;
import com.amazonaws.serverless.proxy.internal.RequestReader;
import com.amazonaws.serverless.proxy.internal.ResponseWriter;
import com.amazonaws.serverless.proxy.internal.SecurityContextWriter;
import com.amazonaws.services.lambda.runtime.Context;
import java.util.concurrent.CountDownLatch;
import javax.ws.rs.core.SecurityContext;

public abstract class LambdaContainerHandler<RequestType, ResponseType, ContainerRequestType, ContainerResponseType> {
    private RequestReader<RequestType, ContainerRequestType> requestReader;
    private ResponseWriter<ContainerResponseType, ResponseType> responseWriter;
    private SecurityContextWriter<RequestType> securityContextWriter;
    private ExceptionHandler<ResponseType> exceptionHandler;

    protected LambdaContainerHandler(RequestReader<RequestType, ContainerRequestType> requestReader, ResponseWriter<ContainerResponseType, ResponseType> responseWriter, SecurityContextWriter<RequestType> securityContextWriter, ExceptionHandler<ResponseType> exceptionHandler) {
        this.requestReader = requestReader;
        this.responseWriter = responseWriter;
        this.securityContextWriter = securityContextWriter;
        this.exceptionHandler = exceptionHandler;
    }

    protected abstract ContainerResponseType getContainerResponse(CountDownLatch var1);

    protected abstract void handleRequest(ContainerRequestType var1, ContainerResponseType var2, Context var3) throws Exception;

    public ResponseType proxy(RequestType request, Context context) {
        try {
            SecurityContext securityContext = this.securityContextWriter.writeSecurityContext(request, context);
            CountDownLatch latch = new CountDownLatch(1);
            ContainerResponseType containerResponse = this.getContainerResponse(latch);
            ContainerRequestType containerRequest = this.requestReader.readRequest(request, securityContext, context);
            this.handleRequest(containerRequest, containerResponse, context);
            latch.await();
            return this.responseWriter.writeResponse(containerResponse, context);
        }
        catch (Exception e) {
            context.getLogger().log("Error while handling request: " + e.getMessage());
            e.printStackTrace();
            return this.exceptionHandler.handle(e);
        }
    }
}

