/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.serverless.proxy.internal;

import com.amazonaws.serverless.exceptions.InvalidRequestEventException;
import com.amazonaws.serverless.proxy.internal.ExceptionHandler;
import com.amazonaws.serverless.proxy.internal.model.AwsProxyResponse;
import com.amazonaws.serverless.proxy.internal.model.ErrorModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class AwsProxyExceptionHandler
implements ExceptionHandler<AwsProxyResponse> {
    static final String INTERNAL_SERVER_ERROR = "Internal Server Error";
    static final String GATEWAY_TIMEOUT_ERROR = "Gateway timeout";
    private static Map<String, String> headers = new HashMap<String, String>();
    private static ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public AwsProxyResponse handle(Throwable ex) {
        if (ex instanceof InvalidRequestEventException) {
            return new AwsProxyResponse(500, headers, this.getErrorJson(INTERNAL_SERVER_ERROR));
        }
        return new AwsProxyResponse(502, headers, this.getErrorJson(GATEWAY_TIMEOUT_ERROR));
    }

    @Override
    public void handle(Throwable ex, OutputStream stream) throws IOException {
        AwsProxyResponse response = this.handle(ex);
        objectMapper.writeValue(stream, (Object)response);
    }

    String getErrorJson(String message) {
        try {
            return objectMapper.writeValueAsString((Object)new ErrorModel(message));
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return "{ \"message\": \"" + message + "\" }";
        }
    }

    static {
        headers.put("Content-Type", "application/json");
    }
}

