/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.serialization;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Identity;
import software.amazon.awssdk.services.dynamodb.model.OperationType;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;

public class RecordDeserializer
extends JsonDeserializer<Record> {
    public Record deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        Record.Builder recordBuilder = Record.builder();
        if (node.has("eventID")) {
            recordBuilder.eventID(node.get("eventID").asText());
        }
        if (node.has("eventName")) {
            String eventName = node.get("eventName").asText();
            recordBuilder.eventName(OperationType.fromValue((String)eventName));
        }
        if (node.has("eventVersion")) {
            recordBuilder.eventVersion(node.get("eventVersion").asText());
        }
        if (node.has("eventSource")) {
            recordBuilder.eventSource(node.get("eventSource").asText());
        }
        if (node.has("awsRegion")) {
            recordBuilder.awsRegion(node.get("awsRegion").asText());
        }
        if (node.has("userIdentity")) {
            JsonNode identityNode = node.get("userIdentity");
            Identity.Builder identityBuilder = Identity.builder();
            if (identityNode.has("principalId")) {
                identityBuilder.principalId(identityNode.get("principalId").asText());
            }
            if (identityNode.has("type")) {
                identityBuilder.type(identityNode.get("type").asText());
            }
            recordBuilder.userIdentity((Identity)identityBuilder.build());
        }
        if (node.has("dynamodb")) {
            JsonNode dynamodbNode = node.get("dynamodb");
            StreamRecord.Builder streamRecordBuilder = StreamRecord.builder();
            if (dynamodbNode.has("ApproximateCreationDateTime")) {
                long epochMilli = dynamodbNode.get("ApproximateCreationDateTime").asLong();
                streamRecordBuilder.approximateCreationDateTime(Instant.ofEpochMilli(epochMilli));
            }
            if (dynamodbNode.has("Keys")) {
                JsonNode keysNode = dynamodbNode.get("Keys");
                streamRecordBuilder.keys(this.parseAttributeValueMap(keysNode, p));
            }
            if (dynamodbNode.has("NewImage")) {
                JsonNode newImageNode = dynamodbNode.get("NewImage");
                streamRecordBuilder.newImage(this.parseAttributeValueMap(newImageNode, p));
            }
            if (dynamodbNode.has("OldImage")) {
                JsonNode oldImageNode = dynamodbNode.get("OldImage");
                streamRecordBuilder.oldImage(this.parseAttributeValueMap(oldImageNode, p));
            }
            if (dynamodbNode.has("SequenceNumber")) {
                streamRecordBuilder.sequenceNumber(dynamodbNode.get("SequenceNumber").asText());
            }
            if (dynamodbNode.has("SizeBytes")) {
                streamRecordBuilder.sizeBytes(Long.valueOf(dynamodbNode.get("SizeBytes").asLong()));
            }
            if (dynamodbNode.has("StreamViewType")) {
                String viewType = dynamodbNode.get("StreamViewType").asText();
                streamRecordBuilder.streamViewType(StreamViewType.fromValue((String)viewType));
            }
            recordBuilder.dynamodb((StreamRecord)streamRecordBuilder.build());
        }
        return (Record)recordBuilder.build();
    }

    private Map<String, AttributeValue> parseAttributeValueMap(JsonNode node, JsonParser parser) throws IOException {
        HashMap<String, AttributeValue> result = new HashMap<String, AttributeValue>();
        Iterator fields = node.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            String key = (String)field.getKey();
            JsonNode valueNode = (JsonNode)field.getValue();
            AttributeValue value = (AttributeValue)parser.getCodec().treeToValue((TreeNode)valueNode, AttributeValue.class);
            result.put(key, value);
        }
        return result;
    }
}

