/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.adapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.adapter.DynamoDBStreamsClientRecord;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.kinesis.model.ChildShard;
import software.amazon.kinesis.retrieval.GetRecordsResponseAdapter;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class DynamoDBStreamsGetRecordsResponseAdapter
implements GetRecordsResponseAdapter {
    private final GetRecordsResponse response;
    private final List<ChildShard> childShards;

    public DynamoDBStreamsGetRecordsResponseAdapter(GetRecordsResponse response) {
        this.response = response;
        this.childShards = new ArrayList<ChildShard>();
    }

    public List<KinesisClientRecord> records() {
        return this.response.records().stream().map(DynamoDBStreamsClientRecord::fromRecord).collect(Collectors.toList());
    }

    public Long millisBehindLatest() {
        if (this.response.records().isEmpty()) {
            return null;
        }
        Record lastRecord = (Record)this.response.records().get(this.response.records().size() - 1);
        long recordTimestamp = lastRecord.dynamodb().approximateCreationDateTime().toEpochMilli();
        long currentTime = System.currentTimeMillis();
        return Math.max(0L, currentTime - recordTimestamp);
    }

    public List<ChildShard> childShards() {
        return this.childShards;
    }

    public String nextShardIterator() {
        return this.response.nextShardIterator();
    }

    public String requestId() {
        return this.response.responseMetadata().requestId();
    }

    public void addChildShards(List<ChildShard> childShards) {
        this.childShards.addAll(childShards);
    }
}

