/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.polling;

import java.time.Duration;

public class DynamoDBStreamsCatchUpConfig {
    private boolean catchupEnabled = false;
    private long millisBehindLatestThreshold = Duration.ofMinutes(1L).toMillis();
    private int scalingFactor = 3;

    public DynamoDBStreamsCatchUpConfig millisBehindLatestThreshold(long threshold) {
        if (threshold <= 0L) {
            throw new IllegalArgumentException("millisBehindLatestThreshold must be positive, got: " + threshold);
        }
        this.millisBehindLatestThreshold = threshold;
        return this;
    }

    public DynamoDBStreamsCatchUpConfig scalingFactor(int scalingFactor) {
        if (scalingFactor <= 0) {
            throw new IllegalArgumentException("scalingFactor must be positive, got: " + scalingFactor);
        }
        this.scalingFactor = scalingFactor;
        return this;
    }

    public boolean catchupEnabled() {
        return this.catchupEnabled;
    }

    public long millisBehindLatestThreshold() {
        return this.millisBehindLatestThreshold;
    }

    public int scalingFactor() {
        return this.scalingFactor;
    }

    public DynamoDBStreamsCatchUpConfig catchupEnabled(boolean catchupEnabled) {
        this.catchupEnabled = catchupEnabled;
        return this;
    }

    public String toString() {
        return "DynamoDBStreamsCatchUpConfig(catchupEnabled=" + this.catchupEnabled() + ", millisBehindLatestThreshold=" + this.millisBehindLatestThreshold() + ", scalingFactor=" + this.scalingFactor() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBStreamsCatchUpConfig)) {
            return false;
        }
        DynamoDBStreamsCatchUpConfig other = (DynamoDBStreamsCatchUpConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.catchupEnabled() != other.catchupEnabled()) {
            return false;
        }
        if (this.millisBehindLatestThreshold() != other.millisBehindLatestThreshold()) {
            return false;
        }
        return this.scalingFactor() == other.scalingFactor();
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBStreamsCatchUpConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.catchupEnabled() ? 79 : 97);
        long $millisBehindLatestThreshold = this.millisBehindLatestThreshold();
        result = result * 59 + (int)($millisBehindLatestThreshold >>> 32 ^ $millisBehindLatestThreshold);
        result = result * 59 + this.scalingFactor();
        return result;
    }
}

