/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsConsumerTaskFactory;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsDataFetcher;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsLeaseManagementFactory;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsMultiStreamTracker;
import com.amazonaws.services.dynamodbv2.streamsadapter.DynamoDBStreamsSleepTimeController;
import com.amazonaws.services.dynamodbv2.streamsadapter.polling.DynamoDBStreamsCatchUpConfig;
import com.amazonaws.services.dynamodbv2.streamsadapter.polling.DynamoDBStreamsPollingConfig;
import com.amazonaws.services.dynamodbv2.streamsadapter.processor.DynamoDBStreamsShardRecordProcessor;
import com.amazonaws.services.dynamodbv2.streamsadapter.util.KinesisMapperUtil;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.kinesis.checkpoint.CheckpointConfig;
import software.amazon.kinesis.common.InitialPositionInStream;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.StreamConfig;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.coordinator.CoordinatorConfig;
import software.amazon.kinesis.coordinator.Scheduler;
import software.amazon.kinesis.leases.LeaseManagementConfig;
import software.amazon.kinesis.leases.LeaseManagementFactory;
import software.amazon.kinesis.lifecycle.ConsumerTaskFactory;
import software.amazon.kinesis.lifecycle.LifecycleConfig;
import software.amazon.kinesis.metrics.MetricsConfig;
import software.amazon.kinesis.processor.FormerStreamsLeasesDeletionStrategy;
import software.amazon.kinesis.processor.ProcessorConfig;
import software.amazon.kinesis.processor.SingleStreamTracker;
import software.amazon.kinesis.processor.StreamTracker;
import software.amazon.kinesis.retrieval.DataFetcherProviderConfig;
import software.amazon.kinesis.retrieval.RetrievalConfig;
import software.amazon.kinesis.retrieval.RetrievalSpecificConfig;
import software.amazon.kinesis.retrieval.polling.DataFetcher;
import software.amazon.kinesis.retrieval.polling.PollingConfig;
import software.amazon.kinesis.retrieval.polling.SleepTimeController;

public final class StreamsSchedulerFactory {
    private static final Logger log = LoggerFactory.getLogger(StreamsSchedulerFactory.class);

    private StreamsSchedulerFactory() {
    }

    public static StreamTracker createMultiStreamTracker(List<String> dynamoDBStreamArns, @NonNull InitialPositionInStreamExtended initialPositionInStreamExtended, FormerStreamsLeasesDeletionStrategy formerStreamsLeasesDeletionStrategy) {
        if (initialPositionInStreamExtended == null) {
            throw new NullPointerException("initialPositionInStreamExtended is marked non-null but is null");
        }
        if (CollectionUtils.isEmpty(dynamoDBStreamArns)) {
            throw new IllegalArgumentException("Stream ARN list cannot be empty");
        }
        for (String streamArn2 : dynamoDBStreamArns) {
            if (KinesisMapperUtil.isValidDynamoDBStreamArn(streamArn2)) continue;
            throw new IllegalArgumentException("Invalid DynamoDB Stream ARN: " + streamArn2);
        }
        if (initialPositionInStreamExtended.getInitialPositionInStream() != InitialPositionInStream.LATEST && initialPositionInStreamExtended.getInitialPositionInStream() != InitialPositionInStream.TRIM_HORIZON) {
            throw new IllegalArgumentException("Invalid Initial PositionInStream: " + initialPositionInStreamExtended.getInitialPositionInStream());
        }
        List<StreamConfig> streamConfigList = dynamoDBStreamArns.stream().map(streamArn -> new StreamConfig(StreamIdentifier.multiStreamInstance((String)KinesisMapperUtil.createKinesisStreamIdentifierFromDynamoDBStreamsArn(streamArn, true)), initialPositionInStreamExtended, null)).collect(Collectors.toList());
        return new DynamoDBStreamsMultiStreamTracker(streamConfigList, formerStreamsLeasesDeletionStrategy);
    }

    public static StreamTracker createSingleStreamTracker(@NonNull String dynamoDBStreamArn, @NonNull InitialPositionInStreamExtended initialPositionInStreamExtended) {
        if (dynamoDBStreamArn == null) {
            throw new NullPointerException("dynamoDBStreamArn is marked non-null but is null");
        }
        if (initialPositionInStreamExtended == null) {
            throw new NullPointerException("initialPositionInStreamExtended is marked non-null but is null");
        }
        if (!KinesisMapperUtil.isValidDynamoDBStreamArn(dynamoDBStreamArn)) {
            throw new IllegalArgumentException("Invalid DynamoDB Stream ARN: " + dynamoDBStreamArn);
        }
        if (initialPositionInStreamExtended.getInitialPositionInStream() != InitialPositionInStream.LATEST && initialPositionInStreamExtended.getInitialPositionInStream() != InitialPositionInStream.TRIM_HORIZON) {
            throw new IllegalArgumentException("Invalid Initial PositionInStream: " + initialPositionInStreamExtended.getInitialPositionInStream());
        }
        return new SingleStreamTracker(KinesisMapperUtil.createKinesisStreamIdentifierFromDynamoDBStreamsArn(dynamoDBStreamArn, false), initialPositionInStreamExtended);
    }

    public static Scheduler createScheduler(@NonNull CheckpointConfig checkpointConfig, @NonNull CoordinatorConfig coordinatorConfig, @NonNull LeaseManagementConfig leaseManagementConfig, @NonNull LifecycleConfig lifecycleConfig, @NonNull MetricsConfig metricsConfig, @NonNull ProcessorConfig processorConfig, @NonNull RetrievalConfig retrievalConfig, @NonNull AwsCredentialsProvider credentialsProvider, @NonNull Region region) {
        if (checkpointConfig == null) {
            throw new NullPointerException("checkpointConfig is marked non-null but is null");
        }
        if (coordinatorConfig == null) {
            throw new NullPointerException("coordinatorConfig is marked non-null but is null");
        }
        if (leaseManagementConfig == null) {
            throw new NullPointerException("leaseManagementConfig is marked non-null but is null");
        }
        if (lifecycleConfig == null) {
            throw new NullPointerException("lifecycleConfig is marked non-null but is null");
        }
        if (metricsConfig == null) {
            throw new NullPointerException("metricsConfig is marked non-null but is null");
        }
        if (processorConfig == null) {
            throw new NullPointerException("processorConfig is marked non-null but is null");
        }
        if (retrievalConfig == null) {
            throw new NullPointerException("retrievalConfig is marked non-null but is null");
        }
        if (credentialsProvider == null) {
            throw new NullPointerException("credentialsProvider is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        AmazonDynamoDBStreamsAdapterClient amazonDynamoDBStreamsAdapterClient = new AmazonDynamoDBStreamsAdapterClient(credentialsProvider, region);
        return StreamsSchedulerFactory.createScheduler(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, amazonDynamoDBStreamsAdapterClient);
    }

    public static Scheduler createScheduler(@NonNull CheckpointConfig checkpointConfig, @NonNull CoordinatorConfig coordinatorConfig, @NonNull LeaseManagementConfig leaseManagementConfig, @NonNull LifecycleConfig lifecycleConfig, @NonNull MetricsConfig metricsConfig, @NonNull ProcessorConfig processorConfig, @NonNull RetrievalConfig retrievalConfig, @NonNull AwsCredentialsProvider credentialsProvider, @NonNull Region region, @NonNull DynamoDBStreamsCatchUpConfig catchUpConfig) {
        if (checkpointConfig == null) {
            throw new NullPointerException("checkpointConfig is marked non-null but is null");
        }
        if (coordinatorConfig == null) {
            throw new NullPointerException("coordinatorConfig is marked non-null but is null");
        }
        if (leaseManagementConfig == null) {
            throw new NullPointerException("leaseManagementConfig is marked non-null but is null");
        }
        if (lifecycleConfig == null) {
            throw new NullPointerException("lifecycleConfig is marked non-null but is null");
        }
        if (metricsConfig == null) {
            throw new NullPointerException("metricsConfig is marked non-null but is null");
        }
        if (processorConfig == null) {
            throw new NullPointerException("processorConfig is marked non-null but is null");
        }
        if (retrievalConfig == null) {
            throw new NullPointerException("retrievalConfig is marked non-null but is null");
        }
        if (credentialsProvider == null) {
            throw new NullPointerException("credentialsProvider is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        if (catchUpConfig == null) {
            throw new NullPointerException("catchUpConfig is marked non-null but is null");
        }
        AmazonDynamoDBStreamsAdapterClient amazonDynamoDBStreamsAdapterClient = new AmazonDynamoDBStreamsAdapterClient(credentialsProvider, region);
        return StreamsSchedulerFactory.createScheduler(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, amazonDynamoDBStreamsAdapterClient, catchUpConfig);
    }

    public static Scheduler createScheduler(@NonNull CheckpointConfig checkpointConfig, @NonNull CoordinatorConfig coordinatorConfig, @NonNull LeaseManagementConfig leaseManagementConfig, @NonNull LifecycleConfig lifecycleConfig, @NonNull MetricsConfig metricsConfig, @NonNull ProcessorConfig processorConfig, @NonNull RetrievalConfig retrievalConfig, @NonNull DynamoDbStreamsClient dynamoDbStreamsClient, @NonNull Region region) {
        if (checkpointConfig == null) {
            throw new NullPointerException("checkpointConfig is marked non-null but is null");
        }
        if (coordinatorConfig == null) {
            throw new NullPointerException("coordinatorConfig is marked non-null but is null");
        }
        if (leaseManagementConfig == null) {
            throw new NullPointerException("leaseManagementConfig is marked non-null but is null");
        }
        if (lifecycleConfig == null) {
            throw new NullPointerException("lifecycleConfig is marked non-null but is null");
        }
        if (metricsConfig == null) {
            throw new NullPointerException("metricsConfig is marked non-null but is null");
        }
        if (processorConfig == null) {
            throw new NullPointerException("processorConfig is marked non-null but is null");
        }
        if (retrievalConfig == null) {
            throw new NullPointerException("retrievalConfig is marked non-null but is null");
        }
        if (dynamoDbStreamsClient == null) {
            throw new NullPointerException("dynamoDbStreamsClient is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        return StreamsSchedulerFactory.createScheduler(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, dynamoDbStreamsClient, region, new DynamoDBStreamsCatchUpConfig());
    }

    public static Scheduler createScheduler(@NonNull CheckpointConfig checkpointConfig, @NonNull CoordinatorConfig coordinatorConfig, @NonNull LeaseManagementConfig leaseManagementConfig, @NonNull LifecycleConfig lifecycleConfig, @NonNull MetricsConfig metricsConfig, @NonNull ProcessorConfig processorConfig, @NonNull RetrievalConfig retrievalConfig, @NonNull DynamoDbStreamsClient dynamoDbStreamsClient, @NonNull Region region, @NonNull DynamoDBStreamsCatchUpConfig catchUpConfig) {
        if (checkpointConfig == null) {
            throw new NullPointerException("checkpointConfig is marked non-null but is null");
        }
        if (coordinatorConfig == null) {
            throw new NullPointerException("coordinatorConfig is marked non-null but is null");
        }
        if (leaseManagementConfig == null) {
            throw new NullPointerException("leaseManagementConfig is marked non-null but is null");
        }
        if (lifecycleConfig == null) {
            throw new NullPointerException("lifecycleConfig is marked non-null but is null");
        }
        if (metricsConfig == null) {
            throw new NullPointerException("metricsConfig is marked non-null but is null");
        }
        if (processorConfig == null) {
            throw new NullPointerException("processorConfig is marked non-null but is null");
        }
        if (retrievalConfig == null) {
            throw new NullPointerException("retrievalConfig is marked non-null but is null");
        }
        if (dynamoDbStreamsClient == null) {
            throw new NullPointerException("dynamoDbStreamsClient is marked non-null but is null");
        }
        if (region == null) {
            throw new NullPointerException("region is marked non-null but is null");
        }
        if (catchUpConfig == null) {
            throw new NullPointerException("catchUpConfig is marked non-null but is null");
        }
        AmazonDynamoDBStreamsAdapterClient amazonDynamoDBStreamsAdapterClient = new AmazonDynamoDBStreamsAdapterClient(dynamoDbStreamsClient, region);
        return StreamsSchedulerFactory.createScheduler(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, amazonDynamoDBStreamsAdapterClient, catchUpConfig);
    }

    public static Scheduler createScheduler(@NonNull CheckpointConfig checkpointConfig, @NonNull CoordinatorConfig coordinatorConfig, @NonNull LeaseManagementConfig leaseManagementConfig, @NonNull LifecycleConfig lifecycleConfig, @NonNull MetricsConfig metricsConfig, @NonNull ProcessorConfig processorConfig, @NonNull RetrievalConfig retrievalConfig, @NonNull AmazonDynamoDBStreamsAdapterClient amazonDynamoDBStreamsAdapterClient) {
        if (checkpointConfig == null) {
            throw new NullPointerException("checkpointConfig is marked non-null but is null");
        }
        if (coordinatorConfig == null) {
            throw new NullPointerException("coordinatorConfig is marked non-null but is null");
        }
        if (leaseManagementConfig == null) {
            throw new NullPointerException("leaseManagementConfig is marked non-null but is null");
        }
        if (lifecycleConfig == null) {
            throw new NullPointerException("lifecycleConfig is marked non-null but is null");
        }
        if (metricsConfig == null) {
            throw new NullPointerException("metricsConfig is marked non-null but is null");
        }
        if (processorConfig == null) {
            throw new NullPointerException("processorConfig is marked non-null but is null");
        }
        if (retrievalConfig == null) {
            throw new NullPointerException("retrievalConfig is marked non-null but is null");
        }
        if (amazonDynamoDBStreamsAdapterClient == null) {
            throw new NullPointerException("amazonDynamoDBStreamsAdapterClient is marked non-null but is null");
        }
        return StreamsSchedulerFactory.createScheduler(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig, amazonDynamoDBStreamsAdapterClient, new DynamoDBStreamsCatchUpConfig());
    }

    public static Scheduler createScheduler(@NonNull CheckpointConfig checkpointConfig, @NonNull CoordinatorConfig coordinatorConfig, @NonNull LeaseManagementConfig leaseManagementConfig, @NonNull LifecycleConfig lifecycleConfig, @NonNull MetricsConfig metricsConfig, @NonNull ProcessorConfig processorConfig, @NonNull RetrievalConfig retrievalConfig, @NonNull AmazonDynamoDBStreamsAdapterClient amazonDynamoDBStreamsAdapterClient, @NonNull DynamoDBStreamsCatchUpConfig catchUpConfig) {
        if (checkpointConfig == null) {
            throw new NullPointerException("checkpointConfig is marked non-null but is null");
        }
        if (coordinatorConfig == null) {
            throw new NullPointerException("coordinatorConfig is marked non-null but is null");
        }
        if (leaseManagementConfig == null) {
            throw new NullPointerException("leaseManagementConfig is marked non-null but is null");
        }
        if (lifecycleConfig == null) {
            throw new NullPointerException("lifecycleConfig is marked non-null but is null");
        }
        if (metricsConfig == null) {
            throw new NullPointerException("metricsConfig is marked non-null but is null");
        }
        if (processorConfig == null) {
            throw new NullPointerException("processorConfig is marked non-null but is null");
        }
        if (retrievalConfig == null) {
            throw new NullPointerException("retrievalConfig is marked non-null but is null");
        }
        if (amazonDynamoDBStreamsAdapterClient == null) {
            throw new NullPointerException("amazonDynamoDBStreamsAdapterClient is marked non-null but is null");
        }
        if (catchUpConfig == null) {
            throw new NullPointerException("catchUpConfig is marked non-null but is null");
        }
        if (!(processorConfig.shardRecordProcessorFactory().shardRecordProcessor() instanceof DynamoDBStreamsShardRecordProcessor)) {
            throw new IllegalArgumentException("ShardRecordProcessor should be of type DynamoDBStreamsShardRecordProcessor");
        }
        if (!(retrievalConfig.retrievalSpecificConfig() instanceof DynamoDBStreamsPollingConfig)) {
            throw new IllegalArgumentException("RetrievalConfig should be of type DynamoDBStreamsPollingConfig");
        }
        Function<DataFetcherProviderConfig, DataFetcher> dataFetcherProvider = dataFetcherProviderConfig -> new DynamoDBStreamsDataFetcher(amazonDynamoDBStreamsAdapterClient, (DataFetcherProviderConfig)dataFetcherProviderConfig, catchUpConfig);
        PollingConfig pollingConfig = (PollingConfig)retrievalConfig.retrievalSpecificConfig();
        pollingConfig.dataFetcherProvider(dataFetcherProvider);
        pollingConfig.sleepTimeController((SleepTimeController)new DynamoDBStreamsSleepTimeController(catchUpConfig, metricsConfig.metricsFactory()));
        retrievalConfig.retrievalSpecificConfig((RetrievalSpecificConfig)pollingConfig);
        if (!coordinatorConfig.skipShardSyncAtWorkerInitializationIfLeasesExist()) {
            log.warn("skipShardSyncAtWorkerInitializationIfLeasesExist is not set to true. This will cause the worker to delay working on lease. Setting this to true");
            coordinatorConfig.skipShardSyncAtWorkerInitializationIfLeasesExist(true);
        }
        DynamoDBStreamsLeaseManagementFactory dynamoDBStreamsLeaseManagementFactory = new DynamoDBStreamsLeaseManagementFactory(amazonDynamoDBStreamsAdapterClient, leaseManagementConfig, retrievalConfig);
        leaseManagementConfig.leaseManagementFactory((LeaseManagementFactory)dynamoDBStreamsLeaseManagementFactory);
        leaseManagementConfig.consumerTaskFactory((ConsumerTaskFactory)new DynamoDBStreamsConsumerTaskFactory());
        if (leaseManagementConfig.leasesRecoveryAuditorInconsistencyConfidenceThreshold() > 0) {
            log.warn("leasesRecoveryAuditorInconsistencyConfidenceThreshold is greater than 0. DynamoDB Streams adapter does not do hole tracking. Setting this to 0.");
            leaseManagementConfig.leasesRecoveryAuditorInconsistencyConfidenceThreshold(0);
        }
        return new Scheduler(checkpointConfig, coordinatorConfig, leaseManagementConfig, lifecycleConfig, metricsConfig, processorConfig, retrievalConfig);
    }
}

