/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.AmazonDynamoDBStreamsAdapterClient;
import com.amazonaws.services.dynamodbv2.streamsadapter.adapter.DynamoDBStreamsGetRecordsResponseAdapter;
import com.amazonaws.services.dynamodbv2.streamsadapter.common.DynamoDBStreamsRequestsBuilder;
import com.amazonaws.services.dynamodbv2.streamsadapter.polling.DynamoDBStreamsCatchUpConfig;
import com.amazonaws.services.dynamodbv2.streamsadapter.util.KinesisMapperUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.ShardFilter;
import software.amazon.awssdk.services.dynamodb.model.ShardFilterType;
import software.amazon.awssdk.services.dynamodb.model.StreamStatus;
import software.amazon.awssdk.services.kinesis.model.ChildShard;
import software.amazon.awssdk.services.kinesis.model.DescribeStreamResponse;
import software.amazon.awssdk.services.kinesis.model.GetRecordsResponse;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.kinesis.model.GetShardIteratorResponse;
import software.amazon.awssdk.services.kinesis.model.KinesisException;
import software.amazon.awssdk.services.kinesis.model.LimitExceededException;
import software.amazon.awssdk.services.kinesis.model.ResourceNotFoundException;
import software.amazon.awssdk.services.kinesis.model.ShardIteratorType;
import software.amazon.kinesis.common.InitialPositionInStreamExtended;
import software.amazon.kinesis.common.StreamIdentifier;
import software.amazon.kinesis.metrics.MetricsFactory;
import software.amazon.kinesis.metrics.MetricsLevel;
import software.amazon.kinesis.metrics.MetricsScope;
import software.amazon.kinesis.metrics.MetricsUtil;
import software.amazon.kinesis.retrieval.AWSExceptionManager;
import software.amazon.kinesis.retrieval.DataFetcherProviderConfig;
import software.amazon.kinesis.retrieval.DataFetcherResult;
import software.amazon.kinesis.retrieval.GetRecordsResponseAdapter;
import software.amazon.kinesis.retrieval.KinesisClientRecord;
import software.amazon.kinesis.retrieval.RetryableRetrievalException;
import software.amazon.kinesis.retrieval.kpl.ExtendedSequenceNumber;
import software.amazon.kinesis.retrieval.polling.DataFetcher;

public class DynamoDBStreamsDataFetcher
implements DataFetcher {
    private static final Logger log = LoggerFactory.getLogger(DynamoDBStreamsDataFetcher.class);
    private static final String METRICS_PREFIX = "DynamoDBStreamsDataFetcher";
    private static final String OPERATION = "ProcessTask";
    protected static final int MAX_DESCRIBE_STREAM_ATTEMPTS_FOR_CHILD_SHARD_DISCOVERY_ON_NO_RECORDS = 10;
    private static final int DESCRIBE_STREAM_FOR_CHILD_SHARD_DISCOVERY_BACKOFF_ON_NO_RECORDS_MAX_DELAY_IN_MILLIS = 1000;
    private static final int DESCRIBE_STREAM_FOR_CHILD_SHARD_DISCOVERY_BACKOFF_ON_NO_RECORDS_BASE_DELAY_IN_MILLIS = 50;
    @NonNull
    private final DynamoDBStreamsCatchUpConfig catchUpConfig;
    @NonNull
    private final AmazonDynamoDBStreamsAdapterClient amazonDynamoDBStreamsAdapterClient;
    @NonNull
    private final StreamIdentifier streamIdentifier;
    @NonNull
    private final String shardId;
    private final int maxRecords;
    @NonNull
    private final MetricsFactory metricsFactory;
    private final String streamAndShardId;
    private String nextIterator;
    private boolean isShardEndReached;
    private boolean isInitialized;
    private String lastKnownSequenceNumber;
    final Duration maxFutureWait;
    private InitialPositionInStreamExtended initialPositionInStream;
    private String consumerId;
    private static final AWSExceptionManager AWS_EXCEPTION_MANAGER = DynamoDBStreamsDataFetcher.createExceptionManager();
    private static final int DEFAULT_MAX_RECORDS = 1000;
    final DataFetcherResult terminalResult = new DataFetcherResult(){

        public GetRecordsResponseAdapter getResultAdapter() {
            return new DynamoDBStreamsGetRecordsResponseAdapter((software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse)software.amazon.awssdk.services.dynamodb.model.GetRecordsResponse.builder().records(Collections.emptyList()).nextShardIterator(null).build());
        }

        public GetRecordsResponse getResult() {
            throw new UnsupportedOperationException("getResult not implemented for DynamoDBStreamsDataFetcher");
        }

        public GetRecordsResponseAdapter acceptAdapter() {
            DynamoDBStreamsDataFetcher.this.nextIterator = null;
            DynamoDBStreamsDataFetcher.this.isShardEndReached = true;
            return this.getResultAdapter();
        }

        public GetRecordsResponse accept() {
            throw new UnsupportedOperationException("accept not implemented for DynamoDBStreamsDataFetcher");
        }

        public boolean isShardEnd() {
            return true;
        }
    };

    private static AWSExceptionManager createExceptionManager() {
        AWSExceptionManager exceptionManager = new AWSExceptionManager();
        exceptionManager.add(ResourceNotFoundException.class, t -> t);
        exceptionManager.add(KinesisException.class, t -> t);
        exceptionManager.add(SdkException.class, t -> t);
        return exceptionManager;
    }

    public DynamoDBStreamsDataFetcher(@NotNull AmazonDynamoDBStreamsAdapterClient amazonDynamoDBStreamsAdapterClient, DataFetcherProviderConfig dynamoDBStreamsDataFetcherProviderConfig, @NotNull DynamoDBStreamsCatchUpConfig catchUpConfig) {
        this.amazonDynamoDBStreamsAdapterClient = amazonDynamoDBStreamsAdapterClient;
        this.catchUpConfig = catchUpConfig;
        this.maxRecords = Math.min(dynamoDBStreamsDataFetcherProviderConfig.getMaxRecords(), 1000);
        this.metricsFactory = dynamoDBStreamsDataFetcherProviderConfig.getMetricsFactory();
        this.streamIdentifier = dynamoDBStreamsDataFetcherProviderConfig.getStreamIdentifier();
        this.shardId = dynamoDBStreamsDataFetcherProviderConfig.getShardId();
        this.streamAndShardId = String.format("%s:%s", KinesisMapperUtil.createDynamoDBStreamsArnFromKinesisStreamName(this.streamIdentifier.streamName()), this.shardId);
        this.maxFutureWait = dynamoDBStreamsDataFetcherProviderConfig.getKinesisRequestTimeout();
        this.consumerId = dynamoDBStreamsDataFetcherProviderConfig.consumerId();
    }

    public DataFetcherResult getRecords() {
        if (!this.isInitialized) {
            throw new IllegalStateException("DynamoDBStreamsDataFetcher.getRecords method called before initialization.");
        }
        if (this.nextIterator != null) {
            try {
                return new AdvancingResult(this.ddbGetRecords(this.nextIterator));
            }
            catch (ResourceNotFoundException e) {
                log.info("Caught ResourceNotFoundException when fetching records for stream and shard {}", (Object)this.streamAndShardId);
                return this.terminalResult;
            }
        }
        return this.terminalResult;
    }

    public void initialize(String initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        log.info("Initializing stream and shard: {} with: {}", (Object)this.streamAndShardId, (Object)initialCheckpoint);
        this.advanceIteratorTo(initialCheckpoint, initialPositionInStream);
        this.isInitialized = true;
    }

    public void initialize(ExtendedSequenceNumber initialCheckpoint, InitialPositionInStreamExtended initialPositionInStream) {
        log.info("Initializing stream and shard: {} with: {}", (Object)this.streamAndShardId, (Object)initialCheckpoint.sequenceNumber());
        this.advanceIteratorTo(initialCheckpoint.sequenceNumber(), initialPositionInStream);
        this.isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void advanceIteratorTo(String sequenceNumber, InitialPositionInStreamExtended initialPositionInStream) {
        if (sequenceNumber == null) {
            throw new IllegalArgumentException("SequenceNumber should not be null: shardId " + this.shardId);
        }
        GetShardIteratorRequest.Builder getShardIteratorRequestBuilder = GetShardIteratorRequest.builder().streamName(KinesisMapperUtil.createDynamoDBStreamsArnFromKinesisStreamName(this.streamIdentifier.streamName())).shardId(this.shardId).overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().addApiName(ApiName.builder().name(this.consumerId).version("3.2.1").build())).build());
        if (Objects.equals(ExtendedSequenceNumber.LATEST.sequenceNumber(), sequenceNumber)) {
            getShardIteratorRequestBuilder.shardIteratorType(ShardIteratorType.LATEST);
        } else if (Objects.equals(ExtendedSequenceNumber.TRIM_HORIZON.sequenceNumber(), sequenceNumber)) {
            getShardIteratorRequestBuilder.shardIteratorType(ShardIteratorType.TRIM_HORIZON);
        } else {
            if (Objects.equals(ExtendedSequenceNumber.SHARD_END.sequenceNumber(), sequenceNumber)) {
                this.nextIterator = null;
                this.isShardEndReached = true;
                this.lastKnownSequenceNumber = sequenceNumber;
                this.initialPositionInStream = initialPositionInStream;
                return;
            }
            getShardIteratorRequestBuilder.shardIteratorType(ShardIteratorType.AFTER_SEQUENCE_NUMBER);
            getShardIteratorRequestBuilder.startingSequenceNumber(sequenceNumber);
        }
        GetShardIteratorRequest request = (GetShardIteratorRequest)getShardIteratorRequestBuilder.build();
        log.debug("[GetShardIterator] Request has parameters {}", (Object)request);
        MetricsScope metricsScope = MetricsUtil.createMetricsWithOperation((MetricsFactory)this.metricsFactory, (String)OPERATION);
        MetricsUtil.addStreamId((MetricsScope)metricsScope, (StreamIdentifier)this.streamIdentifier);
        MetricsUtil.addShardId((MetricsScope)metricsScope, (String)this.shardId);
        boolean success = false;
        long startTime = System.currentTimeMillis();
        try {
            try {
                this.nextIterator = this.getNextIterator(request);
                success = true;
            }
            catch (ExecutionException e) {
                throw AWS_EXCEPTION_MANAGER.apply(e.getCause());
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (TimeoutException e) {
                throw new RetryableRetrievalException(e.getMessage(), (Exception)e);
            }
        }
        catch (ResourceNotFoundException e) {
            try {
                log.info("Caught ResourceNotFoundException when getting an iterator for stream and shard {}", (Object)this.streamAndShardId, (Object)e);
                this.nextIterator = null;
            }
            catch (Throwable throwable) {
                MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getShardIterator"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
                MetricsUtil.endScope((MetricsScope)metricsScope);
                throw throwable;
            }
            MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getShardIterator"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
            MetricsUtil.endScope((MetricsScope)metricsScope);
        }
        MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getShardIterator"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
        MetricsUtil.endScope((MetricsScope)metricsScope);
        if (this.nextIterator == null) {
            this.isShardEndReached = true;
        }
        this.lastKnownSequenceNumber = sequenceNumber;
        this.initialPositionInStream = initialPositionInStream;
    }

    public void restartIterator() {
        if (StringUtils.isEmpty((CharSequence)this.lastKnownSequenceNumber) || this.initialPositionInStream == null) {
            throw new IllegalArgumentException("Make sure to initialize the DynamoDBStreamsDataFetcher before restarting the iterator.");
        }
        log.debug("Restarting iterator for sequence number {} on shard id {}", (Object)this.lastKnownSequenceNumber, (Object)this.streamAndShardId);
        this.advanceIteratorTo(this.lastKnownSequenceNumber, this.initialPositionInStream);
    }

    public void resetIterator(String shardIterator, String sequenceNumber, InitialPositionInStreamExtended initialPositionInStream) {
        this.nextIterator = shardIterator;
        this.lastKnownSequenceNumber = sequenceNumber;
        this.initialPositionInStream = initialPositionInStream;
    }

    public GetRecordsResponse getGetRecordsResponse(software.amazon.awssdk.services.kinesis.model.GetRecordsRequest request) throws Exception {
        throw new UnsupportedOperationException("getGetRecordsResponse is not implemented for DynamoDBStreamsDataFetcher");
    }

    public software.amazon.awssdk.services.kinesis.model.GetRecordsRequest getGetRecordsRequest(String nextIterator) {
        throw new UnsupportedOperationException("getGetRecordsRequest is not implemented for DynamoDBStreamsDataFetcher");
    }

    public GetRecordsResponseAdapter getGetRecordsResponse(GetRecordsRequest request) throws ExecutionException, InterruptedException, TimeoutException {
        DescribeStreamResponse describeStreamResponse;
        DynamoDBStreamsGetRecordsResponseAdapter getRecordsResponseAdapter = this.amazonDynamoDBStreamsAdapterClient.getDynamoDBStreamsRecords(request).get();
        if (Objects.isNull(getRecordsResponseAdapter.nextShardIterator()) && (describeStreamResponse = this.getChildShards(this.streamIdentifier.streamName(), this.shardId)) != null) {
            List<ChildShard> childShards = describeStreamResponse.streamDescription().shards().stream().map(shard -> (ChildShard)ChildShard.builder().shardId(shard.shardId()).parentShards((Collection)Stream.of(shard.parentShardId(), shard.adjacentParentShardId()).filter(Objects::nonNull).collect(Collectors.toList())).hashKeyRange(shard.hashKeyRange()).build()).collect(Collectors.toList());
            getRecordsResponseAdapter.addChildShards(childShards);
        }
        return getRecordsResponseAdapter;
    }

    @VisibleForTesting
    protected DescribeStreamResponse getChildShards(String streamName, String shardId) throws InterruptedException {
        int attempts = 0;
        do {
            try {
                DescribeStreamResponse describeStreamResponse = this.amazonDynamoDBStreamsAdapterClient.describeStreamWithFilter(KinesisMapperUtil.createDynamoDBStreamsArnFromKinesisStreamName(streamName), (ShardFilter)ShardFilter.builder().type(ShardFilterType.CHILD_SHARDS).shardId(shardId).build(), this.consumerId);
                if (!describeStreamResponse.streamDescription().shards().isEmpty()) {
                    return describeStreamResponse;
                }
                if (StreamStatus.DISABLED.toString().equals(describeStreamResponse.streamDescription().streamStatusAsString())) {
                    return null;
                }
            }
            catch (LimitExceededException e) {
                log.error("Caught limit exceeded exception while getting child shards for stream and shard: {}", (Object)this.streamAndShardId, (Object)e);
            }
            catch (Exception e) {
                log.error("Caught exception while getting child shards from stream and shard: {}", (Object)this.streamAndShardId, (Object)e);
                return null;
            }
            long delayMillis = Math.min(50L * (1L << ++attempts), 1000L);
            long jitter = (long)((double)delayMillis * 0.2 * (Math.random() - 0.5) * 2.0);
            Thread.sleep(delayMillis += jitter);
        } while (attempts < 10);
        log.error("Finding child shards for stream and shard: {} failed after {} attempts", (Object)this.streamAndShardId, (Object)attempts);
        return null;
    }

    public GetRecordsRequest ddbGetRecordsRequest(String nextIterator) {
        return (GetRecordsRequest)DynamoDBStreamsRequestsBuilder.getRecordsRequestBuilder(this.consumerId, this.catchUpConfig).shardIterator(nextIterator).limit(Integer.valueOf(this.maxRecords)).build();
    }

    public String getNextIterator(GetShardIteratorRequest request) throws ExecutionException, InterruptedException, TimeoutException {
        GetShardIteratorResponse result = this.amazonDynamoDBStreamsAdapterClient.getShardIterator(request).get();
        return result.shardIterator();
    }

    public GetRecordsResponse getRecords(@NonNull String nextIterator) {
        if (nextIterator == null) {
            throw new NullPointerException("nextIterator is marked non-null but is null");
        }
        throw new UnsupportedOperationException("getRecords is not implemented for DynamoDBStreamsDataFetcher");
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GetRecordsResponseAdapter ddbGetRecords(@NonNull String nextIterator) {
        GetRecordsResponseAdapter getRecordsResponseAdapter;
        if (nextIterator == null) {
            throw new NullPointerException("nextIterator is marked non-null but is null");
        }
        GetRecordsRequest getRecordsRequest = this.ddbGetRecordsRequest(nextIterator);
        MetricsScope metricsScope = MetricsUtil.createMetricsWithOperation((MetricsFactory)this.metricsFactory, (String)OPERATION);
        MetricsUtil.addStreamId((MetricsScope)metricsScope, (StreamIdentifier)this.streamIdentifier);
        MetricsUtil.addShardId((MetricsScope)metricsScope, (String)this.shardId);
        boolean success = false;
        long startTime = System.currentTimeMillis();
        try {
            GetRecordsResponseAdapter response = this.getGetRecordsResponse(getRecordsRequest);
            success = true;
            getRecordsResponseAdapter = response;
        }
        catch (ExecutionException e) {
            try {
                throw AWS_EXCEPTION_MANAGER.apply(e.getCause());
                catch (InterruptedException e2) {
                    log.debug("{} : Interrupt called on method, shutdown initiated", (Object)this.streamAndShardId);
                    throw new RuntimeException(e2);
                }
                catch (TimeoutException e3) {
                    throw new RetryableRetrievalException(e3.getMessage(), (Exception)e3);
                }
            }
            catch (Throwable throwable) {
                MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getRecords"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
                MetricsUtil.endScope((MetricsScope)metricsScope);
                throw throwable;
            }
        }
        MetricsUtil.addSuccessAndLatency((MetricsScope)metricsScope, (String)String.format("%s.%s", METRICS_PREFIX, "getRecords"), (boolean)success, (long)startTime, (MetricsLevel)MetricsLevel.DETAILED);
        MetricsUtil.endScope((MetricsScope)metricsScope);
        return getRecordsResponseAdapter;
    }

    @NonNull
    public StreamIdentifier getStreamIdentifier() {
        return this.streamIdentifier;
    }

    String getNextIterator() {
        return this.nextIterator;
    }

    public boolean isShardEndReached() {
        return this.isShardEndReached;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getLastKnownSequenceNumber() {
        return this.lastKnownSequenceNumber;
    }

    class AdvancingResult
    implements DataFetcherResult {
        final GetRecordsResponseAdapter result;

        public GetRecordsResponseAdapter getResultAdapter() {
            return this.result;
        }

        public GetRecordsResponse getResult() {
            throw new UnsupportedOperationException("AdvancingResult.getResult is not implemented for DynamoDBStreamsDataFetcher");
        }

        public GetRecordsResponseAdapter acceptAdapter() {
            DynamoDBStreamsDataFetcher.this.nextIterator = this.result.nextShardIterator();
            if (CollectionUtils.isNotEmpty((Collection)this.result.records())) {
                DynamoDBStreamsDataFetcher.this.lastKnownSequenceNumber = ((KinesisClientRecord)Iterables.getLast((Iterable)this.result.records())).sequenceNumber();
            }
            if (DynamoDBStreamsDataFetcher.this.nextIterator == null) {
                DynamoDBStreamsDataFetcher.this.isShardEndReached = true;
            }
            return this.getResultAdapter();
        }

        public GetRecordsResponse accept() {
            throw new UnsupportedOperationException("AdvancingResult.accept is not implemented for DynamoDBStreamsDataFetcher");
        }

        public boolean isShardEnd() {
            return DynamoDBStreamsDataFetcher.this.isShardEndReached;
        }

        public AdvancingResult(GetRecordsResponseAdapter result) {
            this.result = result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AdvancingResult)) {
                return false;
            }
            AdvancingResult other = (AdvancingResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            GetRecordsResponse this$result = this.getResult();
            GetRecordsResponse other$result = other.getResult();
            return !(this$result == null ? other$result != null : !this$result.equals(other$result));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AdvancingResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GetRecordsResponse $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            return result;
        }

        public String toString() {
            return "DynamoDBStreamsDataFetcher.AdvancingResult(result=" + this.getResult() + ")";
        }
    }
}

