/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.util;

import com.amazonaws.services.dynamodbv2.streamsadapter.util.KinesisMapperUtil;
import java.time.Instant;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import software.amazon.kinesis.exceptions.internal.KinesisClientLibIOException;
import software.amazon.kinesis.leases.Lease;
import software.amazon.kinesis.leases.MultiStreamLease;

public final class StreamsLeaseCleanupValidator {
    private static final Log LOG = LogFactory.getLog(StreamsLeaseCleanupValidator.class);

    private StreamsLeaseCleanupValidator() {
    }

    public static boolean isCandidateForCleanup(Lease lease, Set<String> currentKinesisShardIds, boolean isMultiStreamMode) throws KinesisClientLibIOException {
        String shardId;
        boolean isCandidateForCleanup = true;
        if (isMultiStreamMode) {
            if (!(lease instanceof MultiStreamLease)) {
                throw new IllegalArgumentException("Expected MultiStreamLease but got " + lease.getClass().getName());
            }
            shardId = ((MultiStreamLease)lease).shardId();
        } else {
            shardId = lease.leaseKey();
        }
        if (Instant.now().isBefore(KinesisMapperUtil.getShardCreationTime(shardId).plus(KinesisMapperUtil.MIN_LEASE_RETENTION_DURATION_IN_HOURS))) {
            return false;
        }
        if (currentKinesisShardIds.contains(shardId)) {
            isCandidateForCleanup = false;
        } else {
            LOG.info((Object)String.format("Found lease for non-existent shard: %s. Checking its parent shards", shardId));
            Set parentShardIds = lease.parentShardIds();
            for (String parentShardId : parentShardIds) {
                if (!currentKinesisShardIds.contains(parentShardId)) continue;
                String message = "Parent shard " + parentShardId + " exists but not the child shard " + shardId;
                LOG.info((Object)message);
                throw new KinesisClientLibIOException(message);
            }
        }
        return isCandidateForCleanup;
    }

    public static boolean isCandidateForCleanup(Lease lease, Set<String> currentKinesisShardIds) throws KinesisClientLibIOException {
        return StreamsLeaseCleanupValidator.isCandidateForCleanup(lease, currentKinesisShardIds, false);
    }
}

