/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.serialization;

import com.amazonaws.services.dynamodbv2.streamsadapter.serialization.AttributeValueDeserializer;
import com.amazonaws.services.dynamodbv2.streamsadapter.serialization.AttributeValueSerializer;
import com.amazonaws.services.dynamodbv2.streamsadapter.serialization.InstantAsMillisSerializer;
import com.amazonaws.services.dynamodbv2.streamsadapter.serialization.RecordDeserializer;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.Identity;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.dynamodb.model.StreamRecord;
import software.amazon.awssdk.services.dynamodb.model.StreamViewType;

public class RecordObjectMapper
extends ObjectMapper {
    public static final String USER_IDENTITY = "userIdentity";
    public static final String OLD_IMAGE = "OldImage";
    public static final String NEW_IMAGE = "NewImage";
    public static final String STREAM_VIEW_TYPE = "StreamViewType";
    public static final String SEQUENCE_NUMBER = "SequenceNumber";
    public static final String SIZE_BYTES = "SizeBytes";
    public static final String KEYS = "Keys";
    public static final String AWS_REGION = "awsRegion";
    public static final String DYNAMODB = "dynamodb";
    public static final String EVENT_ID = "eventID";
    public static final String EVENT_NAME = "eventName";
    public static final String EVENT_SOURCE = "eventSource";
    public static final String EVENT_VERSION = "eventVersion";
    public static final String APPROXIMATE_CREATION_DATE_TIME = "ApproximateCreationDateTime";
    private static final String MODULE = "custom";

    public RecordObjectMapper() {
        this.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        SimpleModule module = new SimpleModule(MODULE, Version.unknownVersion());
        module.addSerializer(ByteBuffer.class, (JsonSerializer)new ByteBufferSerializer());
        module.addDeserializer(ByteBuffer.class, (JsonDeserializer)new ByteBufferDeserializer());
        module.addSerializer(AttributeValue.class, (JsonSerializer)new AttributeValueSerializer());
        module.addDeserializer(AttributeValue.class, (JsonDeserializer)new AttributeValueDeserializer());
        module.addSerializer(Instant.class, (JsonSerializer)new InstantAsMillisSerializer());
        module.addDeserializer(Record.class, (JsonDeserializer)new RecordDeserializer());
        this.registerModule((Module)module);
        this.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        this.addMixIn(Identity.class, IdentityMixIn.class);
        this.addMixIn(AttributeValue.class, AttributeValueMixIn.class);
        this.addMixIn(Record.class, RecordMixIn.class);
        this.addMixIn(StreamRecord.class, StreamRecordMixIn.class);
    }

    private static class ByteBufferSerializer
    extends JsonSerializer<ByteBuffer> {
        private ByteBufferSerializer() {
        }

        public void serialize(ByteBuffer value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeBinary(value.array());
        }
    }

    private static class ByteBufferDeserializer
    extends JsonDeserializer<ByteBuffer> {
        private ByteBufferDeserializer() {
        }

        public ByteBuffer deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            return ByteBuffer.wrap(jp.getBinaryValue());
        }
    }

    private static abstract class IdentityMixIn {
        private IdentityMixIn() {
        }

        @JsonProperty(value="principalId")
        public abstract String principalId();

        @JsonProperty(value="type")
        public abstract String type();
    }

    private static abstract class AttributeValueMixIn {
        private AttributeValueMixIn() {
        }
    }

    private static abstract class RecordMixIn {
        private RecordMixIn() {
        }

        @JsonProperty(value="awsRegion")
        public abstract String awsRegion();

        @JsonProperty(value="dynamodb")
        public abstract StreamRecord dynamodb();

        @JsonProperty(value="eventID")
        public abstract String eventID();

        @JsonProperty(value="eventName")
        public abstract String eventName();

        @JsonProperty(value="eventSource")
        public abstract String eventSource();

        @JsonProperty(value="eventVersion")
        public abstract String eventVersion();

        @JsonProperty(value="userIdentity")
        public abstract Identity userIdentity();
    }

    private static abstract class StreamRecordMixIn {
        private StreamRecordMixIn() {
        }

        @JsonProperty(value="SizeBytes")
        public abstract Long sizeBytes();

        @JsonProperty(value="SequenceNumber")
        public abstract String sequenceNumber();

        @JsonProperty(value="StreamViewType")
        public abstract StreamViewType streamViewType();

        @JsonProperty(value="Keys")
        public abstract Map<String, AttributeValue> keys();

        @JsonProperty(value="NewImage")
        public abstract Map<String, AttributeValue> newImage();

        @JsonProperty(value="OldImage")
        public abstract Map<String, AttributeValue> oldImage();

        @JsonProperty(value="ApproximateCreationDateTime")
        public abstract Instant approximateCreationDateTime();
    }
}

