/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.common;

import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.services.dynamodb.model.DescribeStreamRequest;
import software.amazon.awssdk.services.dynamodb.model.GetRecordsRequest;
import software.amazon.awssdk.services.dynamodb.model.GetShardIteratorRequest;
import software.amazon.awssdk.services.dynamodb.model.ListStreamsRequest;

public final class DynamoDBStreamsRequestsBuilder {
    private DynamoDBStreamsRequestsBuilder() {
    }

    public static ListStreamsRequest.Builder listStreamsRequestBuilder() {
        return DynamoDBStreamsRequestsBuilder.appendUserAgent(ListStreamsRequest.builder());
    }

    public static ListStreamsRequest.Builder listStreamsRequestBuilder(String consumerId) {
        return DynamoDBStreamsRequestsBuilder.appendUserAgent(ListStreamsRequest.builder(), consumerId);
    }

    public static GetRecordsRequest.Builder getRecordsRequestBuilder() {
        return DynamoDBStreamsRequestsBuilder.appendUserAgent(GetRecordsRequest.builder());
    }

    public static GetRecordsRequest.Builder getRecordsRequestBuilder(String consumerId) {
        return DynamoDBStreamsRequestsBuilder.appendUserAgent(GetRecordsRequest.builder(), consumerId);
    }

    public static GetShardIteratorRequest.Builder getShardIteratorRequestBuilder() {
        return DynamoDBStreamsRequestsBuilder.appendUserAgent(GetShardIteratorRequest.builder());
    }

    public static GetShardIteratorRequest.Builder getShardIteratorRequestBuilder(String consumerId) {
        return DynamoDBStreamsRequestsBuilder.appendUserAgent(GetShardIteratorRequest.builder(), consumerId);
    }

    public static DescribeStreamRequest.Builder describeStreamRequestBuilder() {
        return DynamoDBStreamsRequestsBuilder.appendUserAgent(DescribeStreamRequest.builder());
    }

    public static DescribeStreamRequest.Builder describeStreamRequestBuilder(String consumerId) {
        return DynamoDBStreamsRequestsBuilder.appendUserAgent(DescribeStreamRequest.builder(), consumerId);
    }

    private static <T extends AwsRequest.Builder> T appendUserAgent(T builder) {
        return (T)builder.overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().addApiName(ApiName.builder().name("amazon-kinesis-client-library-java").version("3.1.1").build())).build());
    }

    private static <T extends AwsRequest.Builder> T appendUserAgent(T builder, String consumerId) {
        return (T)builder.overrideConfiguration(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().addApiName(ApiName.builder().name(String.format("%s-%s", consumerId, "amazon-kinesis-client-library-java")).version("3.1.1").build())).build());
    }
}

