/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.adapter;

import com.amazonaws.services.dynamodbv2.streamsadapter.serialization.RecordObjectMapper;
import com.amazonaws.services.schemaregistry.common.Schema;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.dynamodb.model.Record;
import software.amazon.awssdk.services.kinesis.model.EncryptionType;
import software.amazon.kinesis.retrieval.KinesisClientRecord;

public class DynamoDBStreamsClientRecord
extends KinesisClientRecord {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DynamoDBStreamsClientRecord.class);
    private static final ObjectMapper MAPPER = new RecordObjectMapper();
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private final Record record;

    protected DynamoDBStreamsClientRecord(String sequenceNumber, Instant approximateArrivalTimestamp, ByteBuffer data, String partitionKey, EncryptionType encryptionType, long subSequenceNumber, String explicitHashKey, boolean aggregated, Schema schema, Record record) {
        super(sequenceNumber, approximateArrivalTimestamp, data, partitionKey, encryptionType, subSequenceNumber, explicitHashKey, aggregated, schema);
        this.record = record;
    }

    public static DynamoDBStreamsClientRecord fromRecord(Record record) {
        return new DynamoDBStreamsClientRecord(record.dynamodb().sequenceNumber(), record.dynamodb().approximateCreationDateTime(), DynamoDBStreamsClientRecord.getData(record), record.dynamodb().sequenceNumber(), EncryptionType.NONE, 0L, null, false, null, record);
    }

    private static ByteBuffer getData(Record record) {
        ByteBuffer data;
        try {
            data = ByteBuffer.wrap(MAPPER.writeValueAsString((Object)record).getBytes(DEFAULT_CHARSET));
        }
        catch (JsonProcessingException e) {
            String errorMessage = "Failed to serialize stream record to JSON";
            log.error("Failed to serialize stream record to JSON", (Throwable)e);
            throw new RuntimeException("Failed to serialize stream record to JSON", e);
        }
        return data;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamoDBStreamsClientRecord)) {
            return false;
        }
        DynamoDBStreamsClientRecord other = (DynamoDBStreamsClientRecord)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Record this$record = this.getRecord();
        Record other$record = other.getRecord();
        return !(this$record == null ? other$record != null : !this$record.equals(other$record));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DynamoDBStreamsClientRecord;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Record $record = this.getRecord();
        result = result * 59 + ($record == null ? 43 : $record.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "DynamoDBStreamsClientRecord(record=" + this.getRecord() + ")";
    }

    @Generated
    public Record getRecord() {
        return this.record;
    }
}

