/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2.streamsadapter.model;

import com.amazonaws.services.dynamodbv2.streamsadapter.model.RecordObjectMapper;
import com.amazonaws.services.kinesis.model.Record;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RecordAdapter
extends Record {
    private static Log LOG = LogFactory.getLog(RecordAdapter.class);
    public static final Charset defaultCharset = Charset.forName("UTF-8");
    private static final ObjectMapper MAPPER = new RecordObjectMapper();
    private final com.amazonaws.services.dynamodbv2.model.Record internalRecord;
    private ByteBuffer data;
    private boolean generateDataBytes;

    public RecordAdapter(com.amazonaws.services.dynamodbv2.model.Record record) {
        this(record, true);
    }

    RecordAdapter(com.amazonaws.services.dynamodbv2.model.Record record, boolean generateDataBytes) {
        this.internalRecord = record;
        this.generateDataBytes = generateDataBytes;
    }

    public com.amazonaws.services.dynamodbv2.model.Record getInternalObject() {
        return this.internalRecord;
    }

    public String getSequenceNumber() {
        return this.internalRecord.getDynamodb().getSequenceNumber();
    }

    public void setSequenceNumber(String sequenceNumber) {
        throw new UnsupportedOperationException();
    }

    public Record withSequenceNumber(String sequenceNumber) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer getData() {
        if (this.data == null) {
            if (this.generateDataBytes) {
                try {
                    this.data = ByteBuffer.wrap(MAPPER.writeValueAsString((Object)this.internalRecord).getBytes(defaultCharset));
                }
                catch (JsonProcessingException e) {
                    String errorMessage = "Failed to serialize stream record to JSON";
                    LOG.error((Object)"Failed to serialize stream record to JSON", (Throwable)e);
                    throw new RuntimeException("Failed to serialize stream record to JSON", e);
                }
            } else {
                this.data = ByteBuffer.wrap(new byte[0]);
            }
        }
        return this.data;
    }

    public void setData(ByteBuffer data) {
        throw new UnsupportedOperationException();
    }

    public Record withData(ByteBuffer data) {
        throw new UnsupportedOperationException();
    }

    public String getPartitionKey() {
        return null;
    }

    public void setPartitionKey(String partitionKey) {
        throw new UnsupportedOperationException();
    }

    public Record withPartitionKey(String partitionKey) {
        throw new UnsupportedOperationException();
    }

    public Date getApproximateArrivalTimestamp() {
        return this.internalRecord.getDynamodb().getApproximateCreationDateTime();
    }

    public void setApproximateArrivalTimestamp(Date approximateArrivalTimestamp) {
        this.internalRecord.getDynamodb().setApproximateCreationDateTime(approximateArrivalTimestamp);
    }

    public Record withApproximateArrivalTimestamp(Date approximateArrivalTimestamp) {
        this.setApproximateArrivalTimestamp(approximateArrivalTimestamp);
        return this;
    }
}

