/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.LockItem;
import java.nio.ByteBuffer;
import java.util.Optional;

public class ReleaseLockOptions {
    private final LockItem lockItem;
    private final boolean deleteLock;
    private final boolean bestEffort;
    private final Optional<ByteBuffer> data;

    ReleaseLockOptions(LockItem lockItem, boolean deleteLock, boolean bestEffort, Optional<ByteBuffer> data) {
        this.lockItem = lockItem;
        this.deleteLock = deleteLock;
        this.bestEffort = bestEffort;
        this.data = data;
    }

    public static ReleaseLockOptionsBuilder builder(LockItem lockItem) {
        return new ReleaseLockOptionsBuilder(lockItem);
    }

    LockItem getLockItem() {
        return this.lockItem;
    }

    boolean isDeleteLock() {
        return this.deleteLock;
    }

    boolean isBestEffort() {
        return this.bestEffort;
    }

    Optional<ByteBuffer> getData() {
        return this.data;
    }

    public static class ReleaseLockOptionsBuilder {
        private LockItem lockItem;
        private boolean deleteLock;
        private boolean bestEffort;
        private Optional<ByteBuffer> data;

        ReleaseLockOptionsBuilder(LockItem lockItem) {
            this.lockItem = lockItem;
            this.deleteLock = true;
            this.bestEffort = false;
            this.data = Optional.empty();
        }

        public ReleaseLockOptionsBuilder withDeleteLock(boolean deleteLock) {
            this.deleteLock = deleteLock;
            return this;
        }

        public ReleaseLockOptionsBuilder withBestEffort(boolean bestEffort) {
            this.bestEffort = bestEffort;
            return this;
        }

        public ReleaseLockOptionsBuilder withData(ByteBuffer data) {
            this.data = Optional.ofNullable(data);
            return this;
        }

        public ReleaseLockOptions build() {
            return new ReleaseLockOptions(this.lockItem, this.deleteLock, this.bestEffort, this.data);
        }

        public String toString() {
            return "ReleaseLockOptions.ReleaseLockOptionsBuilder(lockItem=" + this.lockItem + ", deleteLock=" + this.deleteLock + ", bestEffort=" + this.bestEffort + ", data=" + this.data + ")";
        }
    }
}

