/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.dynamodbv2;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBLockClient;
import com.amazonaws.services.dynamodbv2.SendHeartbeatOptions;
import com.amazonaws.services.dynamodbv2.SessionMonitor;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.LockNotGrantedException;
import com.amazonaws.services.dynamodbv2.model.SessionMonitorNotSetException;
import com.amazonaws.services.dynamodbv2.util.LockClientUtils;
import java.io.Closeable;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

public class LockItem
implements Closeable {
    private final AmazonDynamoDBLockClient client;
    private final String partitionKey;
    private final Optional<String> sortKey;
    private final Optional<ByteBuffer> data;
    private final String ownerName;
    private final boolean deleteLockItemOnClose;
    private final boolean isReleased;
    private final AtomicLong lookupTime;
    private final StringBuffer recordVersionNumber;
    private final AtomicLong leaseDuration;
    private final Map<String, AttributeValue> additionalAttributes;
    private final Optional<SessionMonitor> sessionMonitor;

    LockItem(AmazonDynamoDBLockClient client, String partitionKey, Optional<String> sortKey, Optional<ByteBuffer> data, boolean deleteLockItemOnClose, String ownerName, long leaseDuration, long lastUpdatedTimeInMilliseconds, String recordVersionNumber, boolean isReleased, Optional<SessionMonitor> sessionMonitor, Map<String, AttributeValue> additionalAttributes) {
        Objects.requireNonNull(partitionKey, "Cannot create a lock with a null key");
        Objects.requireNonNull(ownerName, "Cannot create a lock with a null owner");
        Objects.requireNonNull(sortKey, "Cannot create a lock with a null sortKey (use Optional.empty())");
        Objects.requireNonNull(data, "Cannot create a lock with a null data (use Optional.empty())");
        this.client = client;
        this.partitionKey = partitionKey;
        this.sortKey = sortKey;
        this.data = data;
        this.ownerName = ownerName;
        this.deleteLockItemOnClose = deleteLockItemOnClose;
        this.leaseDuration = new AtomicLong(leaseDuration);
        this.lookupTime = new AtomicLong(lastUpdatedTimeInMilliseconds);
        this.recordVersionNumber = new StringBuffer(recordVersionNumber);
        this.isReleased = isReleased;
        this.sessionMonitor = sessionMonitor;
        this.additionalAttributes = additionalAttributes;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public Optional<String> getSortKey() {
        return this.sortKey;
    }

    public Optional<ByteBuffer> getData() {
        return this.data;
    }

    public Map<String, AttributeValue> getAdditionalAttributes() {
        return this.additionalAttributes;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public long getLookupTime() {
        return this.lookupTime.get();
    }

    public String getRecordVersionNumber() {
        return this.recordVersionNumber.toString();
    }

    public long getLeaseDuration() {
        return this.leaseDuration.get();
    }

    public boolean getDeleteLockItemOnClose() {
        return this.deleteLockItemOnClose;
    }

    @Override
    public void close() {
        this.client.releaseLock(this);
    }

    public String toString() {
        return String.format("LockItem{Partition Key=%s, Sort Key=%s, Owner Name=%s, Lookup Time=%d, Lease Duration=%d, Record Version Number=%s, Delete On Close=%s, Is Released=%s}", this.partitionKey, this.sortKey, this.ownerName, this.lookupTime.get(), this.leaseDuration.get(), this.recordVersionNumber, this.deleteLockItemOnClose, this.isReleased);
    }

    public int hashCode() {
        return Arrays.hashCode(Arrays.asList(this.partitionKey, this.ownerName).toArray());
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof LockItem)) {
            return false;
        }
        LockItem otherLockItem = (LockItem)other;
        return this.partitionKey.equals(otherLockItem.getPartitionKey()) && this.ownerName.equals(otherLockItem.getOwnerName());
    }

    public boolean isExpired() {
        if (this.isReleased) {
            return true;
        }
        return LockClientUtils.INSTANCE.millisecondTime() - this.lookupTime.get() > this.leaseDuration.get();
    }

    boolean isReleased() {
        return this.isReleased;
    }

    public void sendHeartBeat() {
        this.client.sendHeartbeat(this);
    }

    public void ensure(long leaseDurationToEnsure, TimeUnit timeUnit) {
        Objects.requireNonNull(timeUnit, "TimeUnit cannot be null");
        if (this.isReleased) {
            throw new LockNotGrantedException("Lock is released");
        }
        long leaseDurationToEnsureInMilliseconds = timeUnit.toMillis(leaseDurationToEnsure);
        if (this.leaseDuration.get() - (LockClientUtils.INSTANCE.millisecondTime() - this.lookupTime.get()) <= leaseDurationToEnsureInMilliseconds) {
            this.client.sendHeartbeat(SendHeartbeatOptions.builder(this).withLeaseDurationToEnsure(leaseDurationToEnsure).withTimeUnit(timeUnit).build());
        }
    }

    void updateRecordVersionNumber(String recordVersionNumber, long lastUpdateOfLock, long leaseDurationToEnsureInMilliseconds) {
        this.recordVersionNumber.replace(0, recordVersionNumber.length(), recordVersionNumber);
        this.lookupTime.set(lastUpdateOfLock);
        this.leaseDuration.set(leaseDurationToEnsureInMilliseconds);
    }

    String getUniqueIdentifier() {
        return this.partitionKey + this.sortKey.orElse("");
    }

    public boolean amIAboutToExpire() {
        return this.millisecondsUntilDangerZoneEntered() <= 0L;
    }

    long millisecondsUntilDangerZoneEntered() {
        if (!this.sessionMonitor.isPresent()) {
            throw new SessionMonitorNotSetException("SessionMonitor is not set");
        }
        if (this.isReleased) {
            throw new IllegalStateException("Lock is already released");
        }
        return this.sessionMonitor.get().millisecondsUntilLeaseEntersDangerZone(this.getLookupTime());
    }

    boolean hasSessionMonitor() {
        return this.sessionMonitor.isPresent();
    }

    boolean hasCallback() {
        if (!this.sessionMonitor.isPresent()) {
            throw new SessionMonitorNotSetException("SessionMonitor is not set");
        }
        return this.sessionMonitor.get().hasCallback();
    }

    void runSessionMonitor() {
        if (!this.sessionMonitor.isPresent()) {
            throw new SessionMonitorNotSetException("Can't run callback without first setting SessionMonitor");
        }
        this.sessionMonitor.get().runCallback();
    }
}

