/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.xray.proxies.apache.http;

import com.amazonaws.xray.AWSXRay;
import com.amazonaws.xray.AWSXRayRecorder;
import com.amazonaws.xray.entities.Namespace;
import com.amazonaws.xray.entities.Segment;
import com.amazonaws.xray.entities.Subsegment;
import com.amazonaws.xray.entities.TraceHeader;
import com.amazonaws.xray.proxies.apache.http.TracedResponseHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

public class TracedHttpClient
extends CloseableHttpClient {
    private final CloseableHttpClient wrappedClient;
    private final AWSXRayRecorder recorder;

    public TracedHttpClient(CloseableHttpClient wrappedClient) {
        this(wrappedClient, AWSXRay.getGlobalRecorder());
    }

    public TracedHttpClient(CloseableHttpClient wrappedClient, AWSXRayRecorder recorder) {
        this.wrappedClient = wrappedClient;
        this.recorder = recorder;
    }

    public static HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        HttpHost target = null;
        URI requestUri = request.getURI();
        if (requestUri.isAbsolute() && (target = URIUtils.extractHost((URI)requestUri)) == null) {
            throw new ClientProtocolException("URI does not specify a valid host name: " + requestUri);
        }
        return target;
    }

    public static String getUrl(HttpUriRequest request) {
        return request.getURI().toString();
    }

    public static String getUrl(HttpHost target, HttpRequest request) {
        String uri = request.getRequestLine().getUri();
        try {
            URI requestUri = new URI(uri);
            if (requestUri.isAbsolute()) {
                return requestUri.toString();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return target.toURI() + uri;
    }

    public static void addRequestInformation(Subsegment subsegment, HttpRequest request, String url) {
        subsegment.setNamespace(Namespace.REMOTE.toString());
        Segment parentSegment = subsegment.getParentSegment();
        TraceHeader header = new TraceHeader(parentSegment.getTraceId(), parentSegment.isSampled() ? subsegment.getId() : null, parentSegment.isSampled() ? TraceHeader.SampleDecision.SAMPLED : TraceHeader.SampleDecision.NOT_SAMPLED);
        request.addHeader("X-Amzn-Trace-Id", header.toString());
        HashMap<String, String> requestInformation = new HashMap<String, String>();
        requestInformation.put("url", url);
        requestInformation.put("method", request.getRequestLine().getMethod());
        subsegment.putHttp("request", requestInformation);
    }

    private <R> R wrapHttpSupplier(Subsegment subsegment, HttpSupplier<R> supplier) throws IOException, ClientProtocolException {
        try {
            R r = supplier.get();
            return r;
        }
        catch (Exception e) {
            if (null != subsegment) {
                subsegment.addException((Throwable)e);
            }
            throw e;
        }
        finally {
            if (null != subsegment) {
                this.recorder.endSubsegment();
            }
        }
    }

    public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Subsegment subsegment = this.recorder.beginSubsegment(target.getHostName());
        return this.wrapHttpSupplier(subsegment, () -> {
            if (null != subsegment) {
                TracedHttpClient.addRequestInformation(subsegment, request, TracedHttpClient.getUrl(target, request));
            }
            CloseableHttpResponse response = this.wrappedClient.execute(target, request, context);
            if (null != subsegment) {
                TracedResponseHandler.addResponseInformation(subsegment, (HttpResponse)response);
            }
            return response;
        });
    }

    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Subsegment subsegment = this.recorder.beginSubsegment(TracedHttpClient.determineTarget(request).getHostName());
        return this.wrapHttpSupplier(subsegment, () -> {
            if (null != subsegment) {
                TracedHttpClient.addRequestInformation(subsegment, (HttpRequest)request, TracedHttpClient.getUrl(request));
            }
            CloseableHttpResponse response = this.wrappedClient.execute(request, context);
            if (null != subsegment) {
                TracedResponseHandler.addResponseInformation(subsegment, (HttpResponse)response);
            }
            return response;
        });
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        Subsegment subsegment = this.recorder.beginSubsegment(TracedHttpClient.determineTarget(request).getHostName());
        return this.wrapHttpSupplier(subsegment, () -> {
            if (null != subsegment) {
                TracedHttpClient.addRequestInformation(subsegment, (HttpRequest)request, TracedHttpClient.getUrl(request));
            }
            CloseableHttpResponse response = this.wrappedClient.execute(request);
            if (null != subsegment) {
                TracedResponseHandler.addResponseInformation(subsegment, (HttpResponse)response);
            }
            return response;
        });
    }

    public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        Subsegment subsegment = this.recorder.beginSubsegment(target.getHostName());
        return this.wrapHttpSupplier(subsegment, () -> {
            if (null != subsegment) {
                TracedHttpClient.addRequestInformation(subsegment, request, TracedHttpClient.getUrl(target, request));
            }
            CloseableHttpResponse response = this.wrappedClient.execute(target, request);
            if (null != subsegment) {
                TracedResponseHandler.addResponseInformation(subsegment, (HttpResponse)response);
            }
            return response;
        });
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        Subsegment subsegment = this.recorder.beginSubsegment(TracedHttpClient.determineTarget(request).getHostName());
        return (T)this.wrapHttpSupplier(subsegment, () -> {
            if (null != subsegment) {
                TracedHttpClient.addRequestInformation(subsegment, (HttpRequest)request, TracedHttpClient.getUrl(request));
            }
            TracedResponseHandler wrappedHandler = new TracedResponseHandler(responseHandler);
            Object response = this.wrappedClient.execute(request, wrappedHandler);
            return response;
        });
    }

    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        Subsegment subsegment = this.recorder.beginSubsegment(TracedHttpClient.determineTarget(request).getHostName());
        return (T)this.wrapHttpSupplier(subsegment, () -> {
            if (null != subsegment) {
                TracedHttpClient.addRequestInformation(subsegment, (HttpRequest)request, TracedHttpClient.getUrl(request));
            }
            TracedResponseHandler wrappedHandler = new TracedResponseHandler(responseHandler);
            Object response = this.wrappedClient.execute(request, wrappedHandler, context);
            return response;
        });
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        Subsegment subsegment = this.recorder.beginSubsegment(target.getHostName());
        return (T)this.wrapHttpSupplier(subsegment, () -> {
            if (null != subsegment) {
                TracedHttpClient.addRequestInformation(subsegment, request, TracedHttpClient.getUrl(target, request));
            }
            TracedResponseHandler wrappedHandler = new TracedResponseHandler(responseHandler);
            Object response = this.wrappedClient.execute(target, request, wrappedHandler);
            return response;
        });
    }

    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        Subsegment subsegment = this.recorder.beginSubsegment(target.getHostName());
        return (T)this.wrapHttpSupplier(subsegment, () -> {
            if (null != subsegment) {
                TracedHttpClient.addRequestInformation(subsegment, request, TracedHttpClient.getUrl(target, request));
            }
            TracedResponseHandler wrappedHandler = new TracedResponseHandler(responseHandler);
            Object response = this.wrappedClient.execute(target, request, wrappedHandler, context);
            return response;
        });
    }

    public ClientConnectionManager getConnectionManager() {
        return this.wrappedClient.getConnectionManager();
    }

    public HttpParams getParams() {
        return this.wrappedClient.getParams();
    }

    public void close() throws IOException {
        this.wrappedClient.close();
    }

    protected CloseableHttpResponse doExecute(HttpHost httpHost, HttpRequest httpRequest, HttpContext httpContext) throws IOException, ClientProtocolException {
        return this.wrappedClient.execute(httpHost, httpRequest, httpContext);
    }

    @FunctionalInterface
    public static interface HttpSupplier<R> {
        public R get() throws IOException, ClientProtocolException;
    }
}

