/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.datatype.joda.deser;

import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonParser;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.core.JsonToken;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.databind.DeserializationContext;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.datatype.joda.cfg.FormatConfig;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.datatype.joda.cfg.JacksonJodaDateFormat;
import com.amazonaws.lambda.thirdparty.com.fasterxml.jackson.datatype.joda.deser.JodaDateDeserializerBase;
import com.amazonaws.lambda.thirdparty.org.joda.time.DateTimeZone;
import com.amazonaws.lambda.thirdparty.org.joda.time.Interval;
import java.io.IOException;

public class IntervalDeserializer
extends JodaDateDeserializerBase<Interval> {
    private static final long serialVersionUID = 1L;

    public IntervalDeserializer() {
        this(FormatConfig.DEFAULT_DATETIME_PARSER);
    }

    public IntervalDeserializer(JacksonJodaDateFormat format) {
        super(Interval.class, format);
    }

    @Override
    public JodaDateDeserializerBase<?> withFormat(JacksonJodaDateFormat format) {
        return new IntervalDeserializer(format);
    }

    @Override
    public Interval deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return this._fromString(p, ctxt, p.getText());
        }
        if (p.isExpectedStartObjectToken()) {
            return this._fromString(p, ctxt, ctxt.extractScalarFromObject(p, this, this.handledType()));
        }
        return (Interval)ctxt.handleUnexpectedToken(this.getValueType(ctxt), p.currentToken(), p, "expected JSON String", new Object[0]);
    }

    protected Interval _fromString(JsonParser p, DeserializationContext ctxt, String value) throws IOException {
        DateTimeZone tz;
        Interval result;
        boolean hasSlash;
        if ((value = value.trim()).isEmpty()) {
            return (Interval)this._fromEmptyString(p, ctxt, value);
        }
        int index = value.indexOf(47, 1);
        boolean bl = hasSlash = index > 0;
        if (!hasSlash) {
            index = value.indexOf(45, 1);
        }
        if (index < 0) {
            throw ctxt.weirdStringException(value, this.handledType(), "no slash or hyphen found to separate start, end");
        }
        String str = value.substring(0, index);
        try {
            if (hasSlash) {
                result = Interval.parseWithOffset(value);
            } else {
                long start = Long.valueOf(str);
                str = value.substring(index + 1);
                long end = Long.valueOf(str);
                result = new Interval(start, end);
            }
        }
        catch (NumberFormatException e) {
            return (Interval)ctxt.handleWeirdStringValue(this.handledType(), str, "Failed to parse number from '%s' (full source String '%s')", str, value);
        }
        DateTimeZone contextTimezone = this._format.shouldAdjustToContextTimeZone(ctxt) ? DateTimeZone.forTimeZone(ctxt.getTimeZone()) : null;
        DateTimeZone dateTimeZone = tz = this._format.isTimezoneExplicit() ? this._format.getTimeZone() : contextTimezone;
        if (tz != null && !tz.equals(result.getStart().getZone())) {
            result = new Interval(result.getStartMillis(), result.getEndMillis(), tz);
        }
        return result;
    }
}

