/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.logging;

import com.amazonaws.services.lambda.runtime.api.client.logging.FrameType;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogSink;
import com.amazonaws.services.lambda.runtime.logging.LogFormat;
import com.amazonaws.services.lambda.runtime.logging.LogLevel;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;

public class FramedTelemetryLogSink
implements LogSink {
    private static final int HEADER_LENGTH = 16;
    private final FileOutputStream logOutputStream;
    private final ByteBuffer headerBuf;

    public FramedTelemetryLogSink(FileDescriptor fd) throws IOException {
        this.logOutputStream = new FileOutputStream(fd);
        this.headerBuf = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public synchronized void log(LogLevel logLevel, LogFormat logFormat, byte[] message) {
        try {
            this.writeFrame(logLevel, logFormat, message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void log(byte[] message) {
        this.log(LogLevel.UNDEFINED, LogFormat.TEXT, message);
    }

    private void writeFrame(LogLevel logLevel, LogFormat logFormat, byte[] message) throws IOException {
        this.updateHeader(logLevel, logFormat, message.length);
        this.logOutputStream.write(this.headerBuf.array());
        this.logOutputStream.write(message);
    }

    private long timestamp() {
        Instant instant = Instant.now();
        return instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000);
    }

    private void updateHeader(LogLevel logLevel, LogFormat logFormat, int length) {
        this.headerBuf.clear();
        this.headerBuf.putInt(FrameType.getValue(logLevel, logFormat));
        this.headerBuf.putInt(length);
        this.headerBuf.putLong(this.timestamp());
        this.headerBuf.flip();
    }

    @Override
    public void close() throws IOException {
        this.logOutputStream.close();
    }
}

