/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client;

import com.amazonaws.services.lambda.crac.Core;
import com.amazonaws.services.lambda.runtime.LambdaLogger;
import com.amazonaws.services.lambda.runtime.api.client.CustomerClassLoader;
import com.amazonaws.services.lambda.runtime.api.client.EventHandlerLoader;
import com.amazonaws.services.lambda.runtime.api.client.HandlerInfo;
import com.amazonaws.services.lambda.runtime.api.client.LambdaEnvironment;
import com.amazonaws.services.lambda.runtime.api.client.LambdaRequestHandler;
import com.amazonaws.services.lambda.runtime.api.client.UserFault;
import com.amazonaws.services.lambda.runtime.api.client.logging.FramedTelemetryLogSink;
import com.amazonaws.services.lambda.runtime.api.client.logging.LambdaContextLogger;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogSink;
import com.amazonaws.services.lambda.runtime.api.client.logging.StdOutLogSink;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.LambdaError;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.LambdaRuntimeApiClient;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.LambdaRuntimeApiClientImpl;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.RapidErrorType;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.converters.LambdaErrorConverter;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.converters.XRayErrorCauseConverter;
import com.amazonaws.services.lambda.runtime.api.client.runtimeapi.dto.InvocationRequest;
import com.amazonaws.services.lambda.runtime.api.client.util.LambdaOutputStream;
import com.amazonaws.services.lambda.runtime.api.client.util.UnsafeUtil;
import com.amazonaws.services.lambda.runtime.logging.LogFormat;
import com.amazonaws.services.lambda.runtime.logging.LogLevel;
import com.amazonaws.services.lambda.runtime.serialization.util.ReflectUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOError;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.URLClassLoader;
import java.security.Security;
import java.util.Properties;

public class AWSLambda {
    protected static URLClassLoader customerClassLoader;
    private static final String TRUST_STORE_PROPERTY = "javax.net.ssl.trustStore";
    private static final String JAVA_SECURITY_PROPERTIES = "java.security.properties";
    private static final String NETWORKADDRESS_CACHE_NEGATIVE_TTL_ENV_VAR = "AWS_LAMBDA_JAVA_NETWORKADDRESS_CACHE_NEGATIVE_TTL";
    private static final String NETWORKADDRESS_CACHE_NEGATIVE_TTL_PROPERTY = "networkaddress.cache.negative.ttl";
    private static final String DEFAULT_NEGATIVE_CACHE_TTL = "1";
    private static final String LAMBDA_TRACE_HEADER_PROP = "com.amazonaws.xray.traceHeader";
    private static final String INIT_TYPE_SNAP_START = "snap-start";
    private static final String AWS_LAMBDA_INITIALIZATION_TYPE;
    private static LambdaRuntimeApiClient runtimeClient;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isNegativeCacheOverridable() {
        String securityPropertiesPath = System.getProperty(JAVA_SECURITY_PROPERTIES);
        if (securityPropertiesPath == null) {
            return true;
        }
        try (FileInputStream inputStream = new FileInputStream(securityPropertiesPath);){
            Properties secProps = new Properties();
            secProps.load(inputStream);
            boolean bl = !secProps.containsKey(NETWORKADDRESS_CACHE_NEGATIVE_TTL_PROPERTY);
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    private static LambdaRequestHandler findRequestHandler(String handlerString, ClassLoader customerClassLoader) {
        HandlerInfo handlerInfo;
        try {
            handlerInfo = HandlerInfo.fromString(handlerString, customerClassLoader);
        }
        catch (HandlerInfo.InvalidHandlerException e) {
            UserFault userFault = UserFault.makeUserFault("Invalid handler: `" + handlerString + "'");
            return new LambdaRequestHandler.UserFaultHandler(userFault);
        }
        catch (ClassNotFoundException e) {
            return LambdaRequestHandler.classNotFound(e, HandlerInfo.className(handlerString));
        }
        catch (NoClassDefFoundError e) {
            return LambdaRequestHandler.initErrorHandler(e, HandlerInfo.className(handlerString));
        }
        catch (Throwable t) {
            throw UserFault.makeInitErrorUserFault(t, HandlerInfo.className(handlerString));
        }
        LambdaRequestHandler requestHandler = EventHandlerLoader.loadEventHandler(handlerInfo);
        if (requestHandler instanceof LambdaRequestHandler.UserFaultHandler) {
            UserFault userFault = ((LambdaRequestHandler.UserFaultHandler)requestHandler).fault;
            if (userFault.fatal.booleanValue()) {
                throw userFault;
            }
        }
        return requestHandler;
    }

    private static LambdaRequestHandler getLambdaRequestHandlerObject(String handler, LambdaContextLogger lambdaLogger) throws ClassNotFoundException, IOException {
        UnsafeUtil.disableIllegalAccessWarning();
        System.setOut(new PrintStream((OutputStream)new LambdaOutputStream(System.out), false, "UTF-8"));
        System.setErr(new PrintStream((OutputStream)new LambdaOutputStream(System.err), false, "UTF-8"));
        AWSLambda.setupRuntimeLogger(lambdaLogger);
        runtimeClient = new LambdaRuntimeApiClientImpl(LambdaEnvironment.RUNTIME_API);
        String taskRoot = System.getProperty("user.dir");
        String libRoot = "/opt/java";
        customerClassLoader = new CustomerClassLoader(taskRoot, libRoot, ClassLoader.getSystemClassLoader());
        Thread.currentThread().setContextClassLoader(customerClassLoader);
        LambdaRequestHandler requestHandler = null;
        try {
            requestHandler = AWSLambda.findRequestHandler(handler, customerClassLoader);
        }
        catch (UserFault userFault) {
            lambdaLogger.log(userFault.reportableError(), lambdaLogger.getLogFormat() == LogFormat.JSON ? LogLevel.ERROR : LogLevel.UNDEFINED);
            LambdaError error = new LambdaError(LambdaErrorConverter.fromUserFault(userFault), RapidErrorType.BadFunctionCode);
            runtimeClient.reportInitError(error);
            System.exit(1);
        }
        if (INIT_TYPE_SNAP_START.equals(AWS_LAMBDA_INITIALIZATION_TYPE)) {
            AWSLambda.onInitComplete(lambdaLogger);
        }
        return requestHandler;
    }

    public static void setupRuntimeLogger(LambdaLogger lambdaLogger) throws ClassNotFoundException {
        ReflectUtil.setStaticField(Class.forName("com.amazonaws.services.lambda.runtime.LambdaRuntime"), (String)"logger", (boolean)true, (Object)lambdaLogger);
    }

    private static FileDescriptor intToFd(int fd) throws RuntimeException {
        try {
            Class<FileDescriptor> clazz = FileDescriptor.class;
            Constructor c = clazz.getDeclaredConstructor(Integer.TYPE);
            c.setAccessible(true);
            return (FileDescriptor)c.newInstance(fd);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static LogSink createLogSink() {
        String fdStr = System.getenv("_LAMBDA_TELEMETRY_LOG_FD");
        if (fdStr == null) {
            return new StdOutLogSink();
        }
        try {
            int fdInt = Integer.parseInt(fdStr);
            FileDescriptor fd = AWSLambda.intToFd(fdInt);
            return new FramedTelemetryLogSink(fd);
        }
        catch (Exception e) {
            return new StdOutLogSink();
        }
    }

    public static void main(String[] args) throws Throwable {
        try (LambdaContextLogger logger = AWSLambda.initLogger();){
            LambdaRequestHandler lambdaRequestHandler = AWSLambda.getLambdaRequestHandlerObject(args[0], logger);
            AWSLambda.startRuntimeLoop(lambdaRequestHandler, logger);
        }
        catch (IOException | ClassNotFoundException t) {
            throw new Error(t);
        }
    }

    private static LambdaContextLogger initLogger() {
        LogSink logSink = AWSLambda.createLogSink();
        LambdaContextLogger logger = new LambdaContextLogger(logSink, LogLevel.fromString((String)LambdaEnvironment.LAMBDA_LOG_LEVEL), LogFormat.fromString((String)LambdaEnvironment.LAMBDA_LOG_FORMAT));
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static void startRuntimeLoop(LambdaRequestHandler requestHandler, LambdaContextLogger lambdaLogger) throws Throwable {
        boolean shouldExit = false;
        while (!shouldExit) {
            LambdaError error;
            UserFault userFault = null;
            InvocationRequest request = runtimeClient.nextInvocation();
            if (request.getXrayTraceId() != null) {
                System.setProperty(LAMBDA_TRACE_HEADER_PROP, request.getXrayTraceId());
            } else {
                System.clearProperty(LAMBDA_TRACE_HEADER_PROP);
            }
            try {
                ByteArrayOutputStream payload = requestHandler.call(request);
                runtimeClient.reportInvocationSuccess(request.getId(), payload.toByteArray());
                Thread.interrupted();
                if (userFault == null) continue;
            }
            catch (UserFault f) {
                shouldExit = f.fatal;
                userFault = f;
                UserFault.filterStackTrace(f);
                error = new LambdaError(LambdaErrorConverter.fromUserFault(f), RapidErrorType.BadFunctionCode);
                runtimeClient.reportInvocationError(request.getId(), error);
                if (userFault == null) continue;
                lambdaLogger.log(userFault.reportableError(), lambdaLogger.getLogFormat() == LogFormat.JSON ? LogLevel.ERROR : LogLevel.UNDEFINED);
                continue;
            }
            catch (Throwable t) {
                shouldExit = t instanceof VirtualMachineError || t instanceof IOError;
                UserFault.filterStackTrace(t);
                userFault = UserFault.makeUserFault(t);
                error = new LambdaError(LambdaErrorConverter.fromThrowable(t), XRayErrorCauseConverter.fromThrowable(t), RapidErrorType.UserException);
                runtimeClient.reportInvocationError(request.getId(), error);
                if (userFault == null) continue;
                lambdaLogger.log(userFault.reportableError(), lambdaLogger.getLogFormat() == LogFormat.JSON ? LogLevel.ERROR : LogLevel.UNDEFINED);
                {
                    catch (Throwable throwable) {
                        if (userFault != null) {
                            lambdaLogger.log(userFault.reportableError(), lambdaLogger.getLogFormat() == LogFormat.JSON ? LogLevel.ERROR : LogLevel.UNDEFINED);
                        }
                        throw throwable;
                    }
                }
                continue;
            }
            lambdaLogger.log(userFault.reportableError(), lambdaLogger.getLogFormat() == LogFormat.JSON ? LogLevel.ERROR : LogLevel.UNDEFINED);
        }
    }

    static void onInitComplete(LambdaContextLogger lambdaLogger) throws IOException {
        try {
            Core.getGlobalContext().beforeCheckpoint(null);
            runtimeClient.restoreNext();
        }
        catch (Exception e1) {
            AWSLambda.logExceptionCloudWatch(lambdaLogger, e1);
            runtimeClient.reportInitError(new LambdaError(LambdaErrorConverter.fromThrowable(e1), RapidErrorType.BeforeCheckpointError));
            System.exit(64);
        }
        try {
            Core.getGlobalContext().afterRestore(null);
        }
        catch (Exception restoreExc) {
            AWSLambda.logExceptionCloudWatch(lambdaLogger, restoreExc);
            runtimeClient.reportRestoreError(new LambdaError(LambdaErrorConverter.fromThrowable(restoreExc), RapidErrorType.AfterRestoreError));
            System.exit(64);
        }
    }

    private static void logExceptionCloudWatch(LambdaContextLogger lambdaLogger, Exception exc) {
        UserFault.filterStackTrace(exc);
        UserFault userFault = UserFault.makeUserFault(exc, true);
        lambdaLogger.log(userFault.reportableError(), lambdaLogger.getLogFormat() == LogFormat.JSON ? LogLevel.ERROR : LogLevel.UNDEFINED);
    }

    static {
        File systemCacerts;
        AWS_LAMBDA_INITIALIZATION_TYPE = System.getenv("AWS_LAMBDA_INITIALIZATION_TYPE");
        Security.setProperty("jdk.tls.disabledAlgorithms", "SSLv3, RC4, MD5withRSA, DH keySize < 1024, EC keySize < 224, DES40_CBC, RC4_40, 3DES_EDE_CBC");
        if (System.getProperty(TRUST_STORE_PROPERTY) == null && (systemCacerts = new File("/etc/pki/java/cacerts")).exists() && systemCacerts.isFile()) {
            System.setProperty(TRUST_STORE_PROPERTY, systemCacerts.getPath());
        }
        if (AWSLambda.isNegativeCacheOverridable()) {
            String ttlFromEnv = System.getenv(NETWORKADDRESS_CACHE_NEGATIVE_TTL_ENV_VAR);
            String negativeCacheTtl = ttlFromEnv == null ? DEFAULT_NEGATIVE_CACHE_TTL : ttlFromEnv;
            Security.setProperty(NETWORKADDRESS_CACHE_NEGATIVE_TTL_PROPERTY, negativeCacheTtl);
        }
    }
}

