/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client.logging;

import com.amazonaws.services.lambda.runtime.api.client.logging.FrameType;
import com.amazonaws.services.lambda.runtime.api.client.logging.LogSink;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.time.Instant;

public class FramedTelemetryLogSink
implements LogSink {
    private static final int HEADER_LENGTH = 16;
    private final FileOutputStream logOutputStream;
    private final ByteBuffer headerBuf;

    public FramedTelemetryLogSink(FileDescriptor fd) throws IOException {
        this.logOutputStream = new FileOutputStream(fd);
        this.headerBuf = ByteBuffer.allocate(16).order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public synchronized void log(byte[] message) {
        try {
            this.writeFrame(message);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeFrame(byte[] message) throws IOException {
        this.updateHeader(message.length);
        this.logOutputStream.write(this.headerBuf.array());
        this.logOutputStream.write(message);
    }

    private long timestamp() {
        Instant instant = Instant.now();
        return instant.getEpochSecond() * 1000000L + (long)(instant.getNano() / 1000);
    }

    private void updateHeader(int length) {
        this.headerBuf.clear();
        this.headerBuf.putInt(FrameType.LOG.getValue());
        this.headerBuf.putInt(length);
        this.headerBuf.putLong(this.timestamp());
        this.headerBuf.flip();
    }

    @Override
    public void close() throws IOException {
        this.logOutputStream.close();
    }
}

