/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.lambda.runtime.api.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClasspathLoader {
    private static final Set<String> BLOCKLIST = new HashSet<String>();
    private static final ClassLoader SYSTEM_CLASS_LOADER = ClassLoader.getSystemClassLoader();
    private static final int CLASS_SUFFIX_LEN = ".class".length();

    private static String pathToClassName(String path) {
        return path.substring(0, path.length() - CLASS_SUFFIX_LEN).replaceAll("/|\\\\", "\\.");
    }

    private static void loadClass(String name) {
        try {
            Class.forName(name, true, SYSTEM_CLASS_LOADER);
        }
        catch (ClassNotFoundException e) {
            System.err.println("[WARN] Failed to load " + name + ": " + e.getMessage());
        }
    }

    private static void loadClassesInJar(File file) throws IOException {
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> en = jar.entries();
        while (en.hasMoreElements()) {
            String name;
            JarEntry entry = en.nextElement();
            if (!entry.getName().endsWith(".class") || BLOCKLIST.contains(name = ClasspathLoader.pathToClassName(entry.getName()))) continue;
            ClasspathLoader.loadClass(name);
        }
    }

    private static void loadClassesInClasspathEntry(String entry) throws IOException {
        File file = new File(entry);
        if (!file.exists()) {
            throw new FileNotFoundException("Classpath entry does not exist: " + file.getPath());
        }
        if (file.isDirectory() || !file.getPath().endsWith(".jar")) {
            System.err.println("[WARN] Only jar classpath entries are supported. Skipping " + file.getPath());
            return;
        }
        ClasspathLoader.loadClassesInJar(file);
    }

    private static void loadAllClasses() throws IOException {
        String classPath = System.getProperty("java.class.path");
        if (classPath == null) {
            return;
        }
        for (String classPathEntry : classPath.split(File.pathSeparator)) {
            ClasspathLoader.loadClassesInClasspathEntry(classPathEntry);
        }
    }

    public static void main(String[] args) throws IOException {
        ClasspathLoader.loadAllClasses();
    }

    static {
        BLOCKLIST.add("com.amazonaws.services.lambda.runtime.api.client.runtimeapi.NativeClient");
        BLOCKLIST.add("META-INF.versions.9.module-info");
    }
}

