/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.s3.internal.crypto;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3EncryptionClient;
import com.amazonaws.services.s3.internal.Mimetypes;
import com.amazonaws.services.s3.internal.RepeatableFileInputStream;
import com.amazonaws.services.s3.internal.S3Direct;
import com.amazonaws.services.s3.internal.crypto.CipherLiteInputStream;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoMaterial;
import com.amazonaws.services.s3.internal.crypto.ContentCryptoScheme;
import com.amazonaws.services.s3.internal.crypto.EncryptionUtils;
import com.amazonaws.services.s3.internal.crypto.MultipartUploadContext;
import com.amazonaws.services.s3.internal.crypto.S3CryptoModule;
import com.amazonaws.services.s3.internal.crypto.S3CryptoScheme;
import com.amazonaws.services.s3.internal.crypto.S3ObjectWrapper;
import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CopyPartRequest;
import com.amazonaws.services.s3.model.CopyPartResult;
import com.amazonaws.services.s3.model.CryptoConfiguration;
import com.amazonaws.services.s3.model.CryptoMode;
import com.amazonaws.services.s3.model.EncryptionMaterials;
import com.amazonaws.services.s3.model.EncryptionMaterialsAccessor;
import com.amazonaws.services.s3.model.EncryptionMaterialsFactory;
import com.amazonaws.services.s3.model.EncryptionMaterialsProvider;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.InstructionFileId;
import com.amazonaws.services.s3.model.MaterialsDescriptionProvider;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutInstructionFileRequest;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.PutObjectResult;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectId;
import com.amazonaws.util.IOUtils;
import com.amazonaws.util.LengthCheckInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.Jackson;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class S3CryptoModuleBase<T extends MultipartUploadContext>
extends S3CryptoModule<T> {
    protected static final int DEFAULT_BUFFER_SIZE = 2048;
    protected final EncryptionMaterialsProvider kekMaterialsProvider;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected final S3CryptoScheme cryptoScheme;
    protected final ContentCryptoScheme contentCryptoScheme;
    protected final CryptoConfiguration cryptoConfig;
    protected final Map<String, T> multipartUploadContexts = Collections.synchronizedMap(new HashMap());
    protected final S3Direct s3;

    protected S3CryptoModuleBase(S3Direct s3, AWSCredentialsProvider credentialsProvider, EncryptionMaterialsProvider kekMaterialsProvider, CryptoConfiguration cryptoConfig) {
        if (!cryptoConfig.isReadOnly()) {
            throw new IllegalArgumentException("The cryto configuration parameter is required to be read-only");
        }
        this.kekMaterialsProvider = kekMaterialsProvider;
        this.s3 = s3;
        this.cryptoConfig = cryptoConfig;
        this.cryptoScheme = S3CryptoScheme.from(cryptoConfig.getCryptoMode());
        this.contentCryptoScheme = this.cryptoScheme.getContentCryptoScheme();
    }

    protected abstract long ciphertextLength(long var1);

    @Override
    public final void abortMultipartUploadSecurely(AbortMultipartUploadRequest req) {
        this.s3.abortMultipartUpload(req);
        this.multipartUploadContexts.remove(req.getUploadId());
    }

    @Override
    public final CopyPartResult copyPartSecurely(CopyPartRequest copyPartRequest) {
        String uploadId = copyPartRequest.getUploadId();
        MultipartUploadContext uploadContext = (MultipartUploadContext)this.multipartUploadContexts.get(uploadId);
        CopyPartResult result = this.s3.copyPart(copyPartRequest);
        if (!uploadContext.hasFinalPartBeenSeen()) {
            uploadContext.setHasFinalPartBeenSeen(true);
        }
        return result;
    }

    protected final ObjectMetadata updateMetadataWithContentCryptoMaterial(ObjectMetadata metadata, File file, ContentCryptoMaterial instruction) {
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (file != null) {
            Mimetypes mimetypes = Mimetypes.getInstance();
            metadata.setContentType(mimetypes.getMimetype(file));
        }
        return instruction.toObjectMetadata(metadata, this.cryptoConfig.getCryptoMode());
    }

    protected final ContentCryptoMaterial createContentCryptoMaterial(AmazonWebServiceRequest req) {
        EncryptionMaterialsFactory f;
        EncryptionMaterials materials;
        if (req instanceof EncryptionMaterialsFactory && (materials = (f = (EncryptionMaterialsFactory)((Object)req)).getEncryptionMaterials()) != null) {
            this.buildContentCryptoMaterial(materials, this.cryptoConfig.getCryptoProvider());
        }
        if (req instanceof MaterialsDescriptionProvider) {
            MaterialsDescriptionProvider mdp = (MaterialsDescriptionProvider)((Object)req);
            return this.newContentCryptoMaterial(this.kekMaterialsProvider, mdp.getMaterialsDescription(), this.cryptoConfig.getCryptoProvider());
        }
        return this.newContentCryptoMaterial(this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider());
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Map<String, String> materialsDescription, Provider provider) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials(materialsDescription);
        return this.buildContentCryptoMaterial(kekMaterials, provider);
    }

    private ContentCryptoMaterial newContentCryptoMaterial(EncryptionMaterialsProvider kekMaterialProvider, Provider provider) {
        EncryptionMaterials kekMaterials = kekMaterialProvider.getEncryptionMaterials();
        if (kekMaterials == null) {
            throw new AmazonClientException("No material available from the encryption material provider");
        }
        return this.buildContentCryptoMaterial(kekMaterials, provider);
    }

    private ContentCryptoMaterial buildContentCryptoMaterial(EncryptionMaterials kekMaterials, Provider provider) {
        SecretKey cek = this.generateCEK();
        byte[] iv = new byte[this.contentCryptoScheme.getIVLengthInBytes()];
        this.cryptoScheme.getSecureRandom().nextBytes(iv);
        return ContentCryptoMaterial.create(cek, iv, kekMaterials, this.cryptoScheme, provider);
    }

    protected final SecretKey generateCEK() {
        try {
            KeyGenerator generator = KeyGenerator.getInstance(this.contentCryptoScheme.getKeyGeneratorAlgorithm());
            generator.init(this.contentCryptoScheme.getKeyLengthInBits(), this.cryptoScheme.getSecureRandom());
            return generator.generateKey();
        }
        catch (NoSuchAlgorithmException e) {
            throw new AmazonClientException("Unable to generate envelope symmetric key:" + e.getMessage(), e);
        }
    }

    protected final PutObjectRequest wrapWithCipher(PutObjectRequest request, ContentCryptoMaterial cekMaterial) {
        ObjectMetadata metadata = request.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        if (metadata.getContentMD5() != null) {
            metadata.addUserMetadata("x-amz-unencrypted-content-md5", metadata.getContentMD5());
        }
        metadata.setContentMD5(null);
        long plaintextLength = this.plaintextLength(request, metadata);
        if (plaintextLength >= 0L) {
            metadata.addUserMetadata("x-amz-unencrypted-content-length", Long.toString(plaintextLength));
            metadata.setContentLength(this.ciphertextLength(plaintextLength));
        }
        request.setMetadata(metadata);
        request.setInputStream(this.newS3CipherLiteInputStream(request, cekMaterial, plaintextLength));
        request.setFile(null);
        return request;
    }

    private CipherLiteInputStream newS3CipherLiteInputStream(PutObjectRequest req, ContentCryptoMaterial cekMaterial, long plaintextLength) {
        try {
            InputStream is = req.getInputStream();
            if (req.getFile() != null) {
                is = new RepeatableFileInputStream(req.getFile());
            }
            if (plaintextLength > -1L) {
                is = new LengthCheckInputStream(is, plaintextLength, false);
            }
            return new CipherLiteInputStream(is, cekMaterial.getCipherLite(), 2048);
        }
        catch (Exception e) {
            throw new AmazonClientException("Unable to create cipher input stream: " + e.getMessage(), e);
        }
    }

    protected final long plaintextLength(PutObjectRequest request, ObjectMetadata metadata) {
        if (request.getFile() != null) {
            return request.getFile().length();
        }
        if (request.getInputStream() != null && metadata.getRawMetadataValue("Content-Length") != null) {
            return metadata.getContentLength();
        }
        return -1L;
    }

    public final S3CryptoScheme getS3CryptoScheme() {
        return this.cryptoScheme;
    }

    protected final PutObjectRequest updateInstructionPutRequest(PutObjectRequest req, ContentCryptoMaterial cekMaterial) {
        byte[] bytes = cekMaterial.toJsonString(this.cryptoConfig.getCryptoMode()).getBytes(StringUtils.UTF8);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectMetadata metadata = req.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
            req.setMetadata(metadata);
        }
        metadata.setContentLength(bytes.length);
        metadata.addUserMetadata("x-amz-crypto-instr-file", "");
        req.setMetadata(metadata);
        req.setInputStream(is);
        req.setFile(null);
        return req;
    }

    protected final PutObjectRequest createInstructionPutRequest(String bucketName, String key, ContentCryptoMaterial cekMaterial) {
        byte[] bytes = cekMaterial.toJsonString(this.cryptoConfig.getCryptoMode()).getBytes(StringUtils.UTF8);
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength(bytes.length);
        metadata.addUserMetadata("x-amz-crypto-instr-file", "");
        InstructionFileId ifileId = new S3ObjectId(bucketName, key).instructionFileId();
        return new PutObjectRequest(ifileId.getBucket(), ifileId.getKey(), is, metadata);
    }

    final <X extends AmazonWebServiceRequest> X appendUserAgent(X request, String userAgent) {
        request.getRequestClientOptions().appendUserAgent(userAgent);
        return request;
    }

    protected void securityCheck(ContentCryptoMaterial cekMaterial, S3ObjectWrapper retrieved) {
    }

    final S3ObjectWrapper fetchInstructionFile(S3ObjectId s3ObjectId, String instFileSuffix) {
        try {
            S3Object o = this.s3.getObject(EncryptionUtils.createInstructionGetRequest(s3ObjectId, instFileSuffix));
            return o == null ? null : new S3ObjectWrapper(o, s3ObjectId);
        }
        catch (AmazonServiceException e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Unable to retrieve instruction file : " + e.getMessage()));
            }
            return null;
        }
    }

    @Override
    public final PutObjectResult putInstructionFileSecurely(PutInstructionFileRequest req) {
        S3ObjectId id = req.getS3ObjectId();
        GetObjectRequest getreq = new GetObjectRequest(id);
        this.appendUserAgent(getreq, AmazonS3EncryptionClient.USER_AGENT);
        S3Object retrieved = this.s3.getObject(getreq);
        if (retrieved == null) {
            throw new IllegalArgumentException("The specified S3 object (" + id + ") doesn't exist.");
        }
        S3ObjectWrapper wrapped = new S3ObjectWrapper(retrieved, id);
        try {
            ContentCryptoMaterial origCCM = this.contentCryptoMaterialOf(wrapped);
            if (ContentCryptoScheme.AES_GCM.equals(origCCM.getContentCryptoScheme()) && this.cryptoConfig.getCryptoMode() == CryptoMode.EncryptionOnly) {
                throw new SecurityException("Lowering the protection of encryption material is not allowed");
            }
            this.securityCheck(origCCM, wrapped);
            EncryptionMaterials newKEK = req.getEncryptionMaterials();
            ContentCryptoMaterial newCCM = newKEK == null ? origCCM.recreate(req.getMaterialsDescription(), (EncryptionMaterialsAccessor)this.kekMaterialsProvider, this.cryptoScheme, this.cryptoConfig.getCryptoProvider()) : origCCM.recreate(newKEK, (EncryptionMaterialsAccessor)this.kekMaterialsProvider, this.cryptoScheme, this.cryptoConfig.getCryptoProvider());
            PutObjectRequest putInstFileRequest = req.createPutObjectRequest(retrieved);
            return this.s3.putObject(this.updateInstructionPutRequest(putInstFileRequest, newCCM));
        }
        catch (RuntimeException ex) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw ex;
        }
        catch (Error error) {
            IOUtils.closeQuietly(retrieved, this.log);
            throw error;
        }
    }

    private ContentCryptoMaterial contentCryptoMaterialOf(S3ObjectWrapper s3w) {
        if (s3w.hasEncryptionInfo()) {
            return ContentCryptoMaterial.fromObjectMetadata(s3w.getObjectMetadata(), this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), false);
        }
        S3ObjectWrapper orig_ifile = this.fetchInstructionFile(s3w.getS3ObjectId(), null);
        if (orig_ifile == null) {
            throw new IllegalArgumentException("S3 object is not encrypted: " + s3w);
        }
        if (!orig_ifile.isInstructionFile()) {
            throw new AmazonClientException("Invalid instruction file for S3 object: " + s3w);
        }
        String json = orig_ifile.toJsonString();
        Map<String, String> instruction = Collections.unmodifiableMap(Jackson.fromJsonString(json, Map.class));
        return ContentCryptoMaterial.fromInstructionFile(instruction, this.kekMaterialsProvider, this.cryptoConfig.getCryptoProvider(), false);
    }
}

