/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.LaunchPermission;
import com.amazonaws.services.ec2.model.LaunchPermissionModifications;
import com.amazonaws.services.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifyImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {
    @Override
    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        LaunchPermissionModifications launchPermissionModificationsLaunchPermission;
        if (modifyImageAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyImageAttributeRequest> request = new DefaultRequest<ModifyImageAttributeRequest>(modifyImageAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2014-05-01");
        if (modifyImageAttributeRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString(modifyImageAttributeRequest.getImageId()));
        }
        if (modifyImageAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString(modifyImageAttributeRequest.getAttribute()));
        }
        if (modifyImageAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString(modifyImageAttributeRequest.getOperationType()));
        }
        List<String> userIdsList = modifyImageAttributeRequest.getUserIds();
        int userIdsListIndex = 1;
        for (String userIdsListValue : userIdsList) {
            if (userIdsListValue != null) {
                request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString(userIdsListValue));
            }
            ++userIdsListIndex;
        }
        List<String> userGroupsList = modifyImageAttributeRequest.getUserGroups();
        int userGroupsListIndex = 1;
        for (String userGroupsListValue : userGroupsList) {
            if (userGroupsListValue != null) {
                request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString(userGroupsListValue));
            }
            ++userGroupsListIndex;
        }
        List<String> productCodesList = modifyImageAttributeRequest.getProductCodes();
        int productCodesListIndex = 1;
        for (String productCodesListValue : productCodesList) {
            if (productCodesListValue != null) {
                request.addParameter("ProductCode." + productCodesListIndex, StringUtils.fromString(productCodesListValue));
            }
            ++productCodesListIndex;
        }
        if (modifyImageAttributeRequest.getValue() != null) {
            request.addParameter("Value", StringUtils.fromString(modifyImageAttributeRequest.getValue()));
        }
        if ((launchPermissionModificationsLaunchPermission = modifyImageAttributeRequest.getLaunchPermission()) != null) {
            List<LaunchPermission> addList = launchPermissionModificationsLaunchPermission.getAdd();
            int addListIndex = 1;
            for (LaunchPermission addListValue : addList) {
                LaunchPermission launchPermissionMember = addListValue;
                if (launchPermissionMember != null) {
                    if (launchPermissionMember.getUserId() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".UserId", StringUtils.fromString(launchPermissionMember.getUserId()));
                    }
                    if (launchPermissionMember.getGroup() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".Group", StringUtils.fromString(launchPermissionMember.getGroup()));
                    }
                }
                ++addListIndex;
            }
            List<LaunchPermission> removeList = launchPermissionModificationsLaunchPermission.getRemove();
            int removeListIndex = 1;
            for (LaunchPermission removeListValue : removeList) {
                LaunchPermission launchPermissionMember = removeListValue;
                if (launchPermissionMember != null) {
                    if (launchPermissionMember.getUserId() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString(launchPermissionMember.getUserId()));
                    }
                    if (launchPermissionMember.getGroup() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".Group", StringUtils.fromString(launchPermissionMember.getGroup()));
                    }
                }
                ++removeListIndex;
            }
        }
        if (modifyImageAttributeRequest.getDescription() != null) {
            request.addParameter("Description.Value", StringUtils.fromString(modifyImageAttributeRequest.getDescription()));
        }
        return request;
    }
}

